/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openksavi.sponge.config.PropertyEntry;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.engine.BaseSpongeEngine;
import org.openksavi.sponge.core.engine.GenericPropertyEntry;
import org.openksavi.sponge.core.kb.DefaultScriptKnowledgeBase;
import org.openksavi.sponge.core.kb.FileKnowledgeBaseScript;
import org.openksavi.sponge.core.kb.StringKnowledgeBaseScript;
import org.openksavi.sponge.engine.EngineParameters;
import org.openksavi.sponge.engine.ExceptionHandler;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseFileProvider;
import org.openksavi.sponge.kb.KnowledgeBaseScript;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.plugin.Plugin;
import org.openksavi.sponge.spi.EngineModuleProvider;
import org.openksavi.sponge.spi.EventQueueProvider;
import org.openksavi.sponge.spi.KnowledgeBaseInterpreterFactoryProvider;
import org.openksavi.sponge.spi.ProcessingUnitProvider;

public class EngineBuilder<T extends BaseSpongeEngine> {
    protected T engine;
    protected List<Plugin> preConfigPlugins = new ArrayList<Plugin>();
    protected List<Plugin> postConfigPlugins = new ArrayList<Plugin>();
    protected AtomicReference<List<Plugin>> additionalPlugins = new AtomicReference<List<Plugin>>(this.preConfigPlugins);
    protected List<KnowledgeBase> preConfigKnowledgeBases = new ArrayList<KnowledgeBase>();
    protected List<KnowledgeBase> postConfigKnowledgeBases = new ArrayList<KnowledgeBase>();
    protected AtomicReference<List<KnowledgeBase>> additionalKnowledgeBases = new AtomicReference<List<KnowledgeBase>>(this.preConfigKnowledgeBases);
    protected Map<String, PropertyEntry> propertyEntries = new LinkedHashMap<String, PropertyEntry>();
    protected Boolean ignoreConfigurationFileNotFound;
    private boolean initialized = false;

    public EngineBuilder(T engine) {
        this.engine = engine;
    }

    public EngineBuilder<T> name(String name) {
        ((BaseEngineModule)this.engine).setName(name);
        return this;
    }

    public EngineBuilder<T> label(String label) {
        ((BaseEngineModule)this.engine).setLabel(label);
        return this;
    }

    public EngineBuilder<T> description(String description) {
        ((BaseEngineModule)this.engine).setDescription(description);
        return this;
    }

    public EngineBuilder<T> license(String license) {
        ((BaseSpongeEngine)this.engine).setLicense(license);
        return this;
    }

    public EngineBuilder<T> moduleProvider(EngineModuleProvider moduleProvider) {
        ((BaseSpongeEngine)this.engine).setModuleProvider(moduleProvider);
        return this;
    }

    public EngineBuilder<T> knowledgeBaseInterpreterFactoryProviders(List<KnowledgeBaseInterpreterFactoryProvider> knowledgeBaseInterpreterFactoryProviders) {
        ((BaseSpongeEngine)this.engine).setKnowledgeBaseInterpreterFactoryProviders(knowledgeBaseInterpreterFactoryProviders);
        return this;
    }

    public EngineBuilder<T> eventQueueProvider(EventQueueProvider eventQueueProvider) {
        ((BaseSpongeEngine)this.engine).setEventQueueProvider(eventQueueProvider);
        return this;
    }

    public EngineBuilder<T> processingUnitProvider(ProcessingUnitProvider processingUnitProvider) {
        ((BaseSpongeEngine)this.engine).setProcessingUnitProvider(processingUnitProvider);
        return this;
    }

    public EngineBuilder<T> knowledgeBaseFileProvider(KnowledgeBaseFileProvider knowledgeBaseFileProvider) {
        ((BaseSpongeEngine)this.engine).setKnowledgeBaseFileProvider(knowledgeBaseFileProvider);
        return this;
    }

    public EngineBuilder<T> config(String configFilename) {
        ((BaseSpongeEngine)this.engine).setConfigurationFilename(configFilename);
        this.additionalPlugins.set(this.postConfigPlugins);
        this.additionalKnowledgeBases.set(this.postConfigKnowledgeBases);
        return this;
    }

    public EngineBuilder<T> property(String name, Object value, boolean variable, boolean system) {
        this.propertyEntries.put(name, new GenericPropertyEntry(value, variable, system));
        return this;
    }

    public EngineBuilder<T> property(String name, Object value) {
        return this.property(name, value, false, false);
    }

    public EngineBuilder<T> systemProperty(String name, Object value) {
        return this.property(name, value, false, true);
    }

    public EngineBuilder<T> variableProperty(String name, Object value) {
        return this.property(name, value, true, false);
    }

    public EngineBuilder<T> properties(Map<String, Object> simpleProperties) {
        simpleProperties.forEach((name, value) -> this.property((String)name, value));
        return this;
    }

    public EngineBuilder<T> systemProperties(Map<String, String> systemProperties) {
        systemProperties.forEach((name, value) -> this.systemProperty((String)name, value));
        return this;
    }

    public EngineBuilder<T> variableProperties(Map<String, String> variableProperties) {
        variableProperties.forEach((name, value) -> this.variableProperty((String)name, value));
        return this;
    }

    public EngineBuilder<T> plugin(Plugin plugin) {
        this.additionalPlugins.get().add(plugin);
        return this;
    }

    public EngineBuilder<T> plugins(Plugin ... plugins) {
        Stream.of(plugins).forEachOrdered(plugin -> this.plugin((Plugin)plugin));
        return this;
    }

    public EngineBuilder<T> knowledgeBase(KnowledgeBase knowledgeBase) {
        this.additionalKnowledgeBases.get().add(knowledgeBase);
        return this;
    }

    public EngineBuilder<T> knowledgeBase(String name, KnowledgeBaseType type, String ... files) {
        return this.knowledgeBase(name, type, Stream.of(files).map(file -> new FileKnowledgeBaseScript((String)file)).collect(Collectors.toList()));
    }

    public EngineBuilder<T> knowledgeBase(String name, String ... files) {
        return this.knowledgeBase(name, Stream.of(files).map(file -> new FileKnowledgeBaseScript((String)file)).collect(Collectors.toList()));
    }

    public EngineBuilder<T> knowledgeBase(String name, KnowledgeBaseScript ... scripts) {
        return this.knowledgeBase(name, null, Stream.of(scripts).collect(Collectors.toList()));
    }

    public EngineBuilder<T> knowledgeBase(String name, KnowledgeBaseType type, KnowledgeBaseScript ... scripts) {
        return this.knowledgeBase(name, type, Stream.of(scripts).collect(Collectors.toList()));
    }

    public EngineBuilder<T> knowledgeBase(String name, List<KnowledgeBaseScript> scripts) {
        return this.knowledgeBase(name, null, scripts);
    }

    public EngineBuilder<T> knowledgeBase(String name, KnowledgeBaseType type, List<KnowledgeBaseScript> scripts) {
        DefaultScriptKnowledgeBase knowledgeBase = new DefaultScriptKnowledgeBase(name, type);
        scripts.forEach(script -> knowledgeBase.addScript((KnowledgeBaseScript)script));
        this.knowledgeBase(knowledgeBase);
        return this;
    }

    public EngineBuilder<T> knowledgeBaseString(String name, KnowledgeBaseType type, String body) {
        return this.knowledgeBase(name, type, Stream.of(new StringKnowledgeBaseScript(body)).collect(Collectors.toList()));
    }

    public EngineBuilder<T> exceptionHandler(ExceptionHandler exceptionHandler) {
        ((BaseSpongeEngine)this.engine).setExceptionHandler(exceptionHandler);
        return this;
    }

    public EngineBuilder<T> defaultKnowledgeBaseName(String defaultKnowledgeBaseName) {
        ((BaseSpongeEngine)this.engine).setDefaultKnowledgeBaseName(defaultKnowledgeBaseName);
        return this;
    }

    public EngineBuilder<T> ignoreConfigurationFileNotFound(Boolean ignoreConfigurationFileNotFound) {
        this.ignoreConfigurationFileNotFound = ignoreConfigurationFileNotFound;
        return this;
    }

    public EngineParameters getEngineDefaultParameters() {
        return ((BaseSpongeEngine)this.engine).getDefaultParameters();
    }

    public EngineBuilder<T> init() {
        if (!this.initialized) {
            ((BaseSpongeEngine)this.engine).init();
            this.initialized = true;
        }
        return this;
    }

    public T build() {
        this.init();
        if (this.propertyEntries != null) {
            ((BaseSpongeEngine)this.engine).getConfigurationManager().setPropertyEntries(this.propertyEntries);
        }
        ((BaseSpongeEngine)this.engine).getConfigurationManager().addPreConfigPlugins(this.preConfigPlugins);
        ((BaseSpongeEngine)this.engine).getConfigurationManager().addPostConfigPlugins(this.postConfigPlugins);
        ((BaseSpongeEngine)this.engine).getConfigurationManager().addPreConfigKnowledgeBases(this.preConfigKnowledgeBases);
        ((BaseSpongeEngine)this.engine).getConfigurationManager().addPostConfigKnowledgeBases(this.postConfigKnowledgeBases);
        if (this.ignoreConfigurationFileNotFound != null) {
            ((BaseSpongeEngine)this.engine).getConfigurationManager().setIgnoreConfigurationFileNotFound(this.ignoreConfigurationFileNotFound.booleanValue());
        }
        return this.engine;
    }

    public String getInfo() {
        return ((BaseSpongeEngine)this.engine).getInfo();
    }
}

