/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.List;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.ProcessorDefinition;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.action.Action;
import org.openksavi.sponge.action.ActionAdapter;
import org.openksavi.sponge.core.engine.DefaultProcessorInstanceHolder;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.InitialProcessorInstance;
import org.openksavi.sponge.engine.ProcessorProvider;
import org.openksavi.sponge.java.core.JavaUtils;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseInterpreter;

public class SingleInstanceProcessorProvider<T extends Processor<?>>
implements ProcessorProvider<T> {
    private Processor<?> processorInstance;

    public SingleInstanceProcessorProvider(Processor<?> processorInstance) {
        this.processorInstance = processorInstance;
    }

    public InitialProcessorInstance<T> createInitialProcessorInstance(KnowledgeBase knowledgeBase, Class<T> cls) {
        Validate.notNull(this.processorInstance, (String)"Null processor instance", (Object[])new Object[0]);
        Validate.isTrue((boolean)SpongeUtils.isSingleton(this.processorInstance), (String)"The processor %s is not a singleton", (Object[])new Object[]{this.processorInstance.getClass()});
        DefaultProcessorInstanceHolder holder = new DefaultProcessorInstanceHolder(this.processorInstance, JavaUtils.createProcessorName(this.processorInstance.getClass()), true);
        return new InitialProcessorInstance(holder.getProcessor(), holder.getName());
    }

    public T createAdditionalProcessorInstance(ProcessorDefinition definition, Class<T> cls) {
        throw new SpongeException("Single instance processors can't have additional instances");
    }

    public Object invokeActionOnCall(Action action, List<Object> args) {
        KnowledgeBaseInterpreter interpreter = ((ActionAdapter)action.getAdapter()).getKnowledgeBase().getEngineOperations().getEngine().getKnowledgeBaseManager().getDefaultKnowledgeBase().getInterpreter();
        return interpreter.invokeMethod((Object)action, "onCall", args != null ? args.toArray(new Object[args.size()]) : new Object[]{});
    }
}

