/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core;

import java.util.Map;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.ProcessorBuilder;
import org.openksavi.sponge.ProcessorOnInitCallback;
import org.openksavi.sponge.core.BaseProcessorMeta;

public abstract class BaseProcessorBuilder<T extends Processor<?>>
implements ProcessorBuilder<T> {
    private BaseProcessorMeta meta;
    private ProcessorOnInitCallback<T> onInitCallback;

    protected BaseProcessorBuilder(BaseProcessorMeta meta, String name) {
        this.meta = meta;
        this.meta.setName(name);
    }

    public final String getName() {
        return this.getMeta().getName();
    }

    protected BaseProcessorMeta getMeta() {
        return this.meta;
    }

    public BaseProcessorBuilder<T> withName(String name) {
        this.getMeta().withName(name);
        return this;
    }

    public BaseProcessorBuilder<T> withLabel(String label) {
        this.getMeta().withLabel(label);
        return this;
    }

    public BaseProcessorBuilder<T> withDescription(String description) {
        this.getMeta().withDescription(description);
        return this;
    }

    public BaseProcessorBuilder<T> withVersion(Integer version) {
        this.getMeta().withVersion(version);
        return this;
    }

    public BaseProcessorBuilder<T> withFeatures(Map<String, Object> features) {
        this.getMeta().withFeatures(features);
        return this;
    }

    public BaseProcessorBuilder<T> withFeature(String name, Object value) {
        this.getMeta().withFeature(name, value);
        return this;
    }

    public BaseProcessorBuilder<T> withCategory(String category) {
        this.getMeta().withCategory(category);
        return this;
    }

    public BaseProcessorBuilder<T> withOnInit(ProcessorOnInitCallback<T> onInitCallback) {
        this.onInitCallback = onInitCallback;
        return this;
    }

    public ProcessorOnInitCallback<T> getOnInitCallback() {
        return this.onInitCallback;
    }

    public void setOnInitCallback(ProcessorOnInitCallback<T> onInitCallback) {
        this.onInitCallback = onInitCallback;
    }
}

