/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.action;

import java.util.Arrays;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.action.Action;
import org.openksavi.sponge.action.ActionOnCallCallback;
import org.openksavi.sponge.action.ActionOnCallNoResultCallback;
import org.openksavi.sponge.action.ActionOnCallResultCallback;
import org.openksavi.sponge.action.IsActionActiveContext;
import org.openksavi.sponge.action.ProvideArgsContext;
import org.openksavi.sponge.core.action.BaseAction;
import org.openksavi.sponge.core.action.BaseActionBuilder;

public class DefaultBuilderAction
extends BaseAction {
    private BaseActionBuilder builder;

    public DefaultBuilderAction(BaseActionBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void onConfigure() {
        this.getMeta().update(this.builder.getMeta());
        Validate.isTrue((!this.getMeta().isCallable() || this.builder.getOnCallCallback() != null ? 1 : 0) != 0, (String)"An onCall callback must be set for a callable action", (Object[])new Object[0]);
    }

    @Override
    public void onInit() {
        if (this.builder.getOnInitCallback() != null) {
            this.builder.getOnInitCallback().onInit((Processor)this);
        } else {
            super.onInit();
        }
    }

    @Override
    public boolean onIsActive(IsActionActiveContext context) {
        if (this.builder.getOnIsActiveCallback() != null) {
            return this.builder.getOnIsActiveCallback().onIsActive((Action)this, context);
        }
        return super.onIsActive(context);
    }

    public Object onCall(Object ... args) {
        ActionOnCallCallback onCall = this.builder.getOnCallCallback();
        if (onCall instanceof ActionOnCallResultCallback) {
            return ((ActionOnCallResultCallback)onCall).onCall((Action)this, Arrays.asList(args));
        }
        if (onCall instanceof ActionOnCallNoResultCallback) {
            ((ActionOnCallNoResultCallback)onCall).onCall((Action)this, Arrays.asList(args));
            return null;
        }
        throw new SpongeException("An onCall callback is not configured properly");
    }

    @Override
    public void onProvideArgs(ProvideArgsContext context) {
        if (this.builder.getOnProvideArgsCallback() != null) {
            this.builder.getOnProvideArgsCallback().onProvideArgs((Action)this, context);
        } else {
            super.onProvideArgs(context);
        }
    }
}

