/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.util.exception;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openksavi.sponge.core.util.exception.ErrorLocationTextInExceptionMessageFinder;
import org.openksavi.sponge.core.util.exception.ScriptExceptionErrorLocationTextInExceptionMessageFinder;
import org.openksavi.sponge.core.util.exception.WrappedExceptionErrorLocationTextInExceptionMessageFinder;
import org.openksavi.sponge.engine.WrappedException;

public abstract class SpongeExceptionUtils {
    private static final Map<Class<? extends Throwable>, ErrorLocationTextInExceptionMessageFinder> errorLocationTextInExceptionMessageFinders = new HashMap<Class<? extends Throwable>, ErrorLocationTextInExceptionMessageFinder>();

    private SpongeExceptionUtils() {
    }

    public static boolean containsException(Throwable exception, Class<? extends Throwable> type) {
        return ExceptionUtils.indexOfType((Throwable)exception, type) > -1;
    }

    public static <T> T getException(Throwable exception, Class<? extends Throwable> type) {
        return (T)ExceptionUtils.getThrowableList((Throwable)exception).get(ExceptionUtils.indexOfType((Throwable)exception, type));
    }

    public static String getErrorMessageWithoutErrorLocation(Throwable exception) {
        String message = exception.getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            return message;
        }
        for (Class<? extends Throwable> exceptionClass : errorLocationTextInExceptionMessageFinders.keySet()) {
            if (!SpongeExceptionUtils.containsException(exception, exceptionClass)) continue;
            message = SpongeExceptionUtils.getExceptionMessageWithoutErrorLocation(message, (Throwable)SpongeExceptionUtils.getException(exception, exceptionClass));
        }
        return message;
    }

    public static String getExceptionMessageWithoutErrorLocation(String message, Throwable exception) {
        if (StringUtils.isEmpty((CharSequence)message)) {
            return message;
        }
        Optional<String> errorLocation = errorLocationTextInExceptionMessageFinders.get(exception.getClass()).getErrorLocationText(exception);
        if (!errorLocation.isPresent()) {
            return message;
        }
        int errorLocationIndex = message.indexOf(errorLocation.get());
        Validate.isTrue((errorLocationIndex > -1 ? 1 : 0) != 0, (String)"Error location message in %s is incorrect", (Object[])new Object[]{exception.getClass()});
        return message.substring(0, errorLocationIndex) + message.substring(errorLocationIndex + errorLocation.get().length());
    }

    static {
        errorLocationTextInExceptionMessageFinders.put(ScriptException.class, new ScriptExceptionErrorLocationTextInExceptionMessageFinder());
        errorLocationTextInExceptionMessageFinders.put(WrappedException.class, new WrappedExceptionErrorLocationTextInExceptionMessageFinder());
    }
}

