/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core;

import org.openksavi.sponge.EventProcessor;
import org.openksavi.sponge.EventProcessorAdapter;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.BaseEventProcessorDefinition;
import org.openksavi.sponge.core.BaseProcessorAdapter;
import org.openksavi.sponge.core.BaseProcessorDefinition;

public abstract class BaseEventProcessorAdapter<T extends EventProcessor<?>>
extends BaseProcessorAdapter<T>
implements EventProcessorAdapter<T> {
    protected BaseEventProcessorAdapter(BaseProcessorDefinition definition) {
        super(definition);
    }

    @Override
    public BaseEventProcessorDefinition getDefinition() {
        return (BaseEventProcessorDefinition)super.getDefinition();
    }

    public String[] getEventNames() {
        return this.getDefinition().getEventNames();
    }

    public String getEventName(int index) {
        return this.getDefinition().getEventName(index);
    }

    public void setEventNames(String ... eventNames) {
        this.getDefinition().setEventNames(eventNames);
    }

    public void setEventName(String eventName) {
        this.getDefinition().setEventNames(eventName);
    }

    @Override
    public void validate() {
        super.validate();
        String[] eventNames = this.getEventNames();
        if (eventNames == null || eventNames.length < 1) {
            throw new SpongeException("Invalid " + this.getType().getName() + " " + this.getName() + ". At least one event must be specified.");
        }
        for (String eventName : eventNames) {
            this.getKnowledgeBase().getEngineOperations().getEngine().getPatternMatcher().validatePattern(eventName);
        }
    }
}

