/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.plugin.KnowledgeBasePluginStub;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.PluginManager;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseInterpreter;
import org.openksavi.sponge.plugin.Plugin;
import org.openksavi.sponge.shaded.com.google.common.collect.ImmutableList;
import org.openksavi.sponge.util.Manageable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginManager
extends BaseEngineModule
implements PluginManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPluginManager.class);
    protected Map<String, Plugin> pluginMap = Collections.synchronizedMap(new LinkedHashMap());

    public DefaultPluginManager(SpongeEngine engine) {
        super("PluginManager", engine);
    }

    public void configure(Configuration configuration) {
        Stream.of(configuration.getChildConfigurationsOf("plugins")).forEachOrdered(pluginConfig -> this.addPlugin(this.createAndConfigurePlugin((Configuration)pluginConfig)));
    }

    public Plugin createAndConfigurePlugin(Configuration pluginConfig) {
        String pluginName = pluginConfig.getAttribute("name", null);
        if (StringUtils.isBlank((CharSequence)pluginName)) {
            throw new SpongeException("Plugin should have a name");
        }
        String className = pluginConfig.getAttribute("class", null);
        if (StringUtils.isBlank((CharSequence)className)) {
            throw new SpongeException("Plugin configuration should specify a class: " + pluginName);
        }
        String knowledgeBaseName = pluginConfig.getAttribute("knowledgeBaseName", null);
        Plugin plugin = this.createPluginStub(pluginName, knowledgeBaseName, className);
        if (this.existsPlugin(plugin.getName())) {
            throw new SpongeException("Plugin '" + plugin.getName() + "' already exists.");
        }
        if (plugin.getName() != null && plugin.getName().equals("EPS")) {
            throw new SpongeException("Invalid plugin name: " + plugin.getName());
        }
        plugin.setDisplayName(pluginConfig.getAttribute("displayName", null));
        plugin.setDescription(pluginConfig.getString("description", null));
        plugin.setConfiguration(pluginConfig.getChildConfiguration("configuration"), true);
        return plugin;
    }

    public boolean existsPlugin(String name) {
        return this.pluginMap.containsKey(name);
    }

    public void addPlugin(Plugin plugin) {
        String name = plugin.getName();
        if (this.pluginMap.containsKey(name)) {
            throw new SpongeException("Plugin '" + name + "' already exists");
        }
        logger.debug("Adding plugin '{}'.", (Object)name);
        this.pluginMap.put(name, plugin);
        plugin.setEngine(this.getEngine());
        if (this.isRunning()) {
            this.initPlugin(plugin);
            plugin.startup();
            this.definePluginVariable(name, plugin);
        }
    }

    public void removePlugin(Plugin plugin) {
        plugin.setEngine(null);
        this.pluginMap.remove(plugin.getName());
        this.definePluginVariable(plugin.getName(), null);
    }

    public List<Plugin> getPlugins() {
        return ImmutableList.copyOf(this.pluginMap.values());
    }

    public Plugin getPlugin(String name) {
        return this.pluginMap.get(name);
    }

    public <T extends Plugin> T getPlugin(String name, Class<T> cls) {
        Plugin plugin = this.pluginMap.get(name);
        if (plugin == null) {
            return null;
        }
        if (cls.isInstance(plugin)) {
            return (T)plugin;
        }
        throw new SpongeException("Plugin '" + name + "' should be an instance of " + cls);
    }

    public <T extends Plugin> T getPlugin(Class<T> cls) {
        List plugins = this.pluginMap.values().stream().filter(plugin -> cls.isInstance(plugin)).map(plugin -> plugin).collect(Collectors.toList());
        if (plugins.isEmpty()) {
            return null;
        }
        if (plugins.size() > 1) {
            throw new SpongeException("There are more than one plugins of type " + cls);
        }
        return (T)((Plugin)plugins.get(0));
    }

    protected Plugin createPluginStub(String pluginName, String knowledgeBaseName, String pluginClassName) {
        try {
            KnowledgeBasePluginStub plugin = new KnowledgeBasePluginStub(knowledgeBaseName, pluginClassName);
            plugin.setName(pluginName);
            return plugin;
        }
        catch (Throwable e) {
            throw SpongeUtils.wrapException(pluginName, e);
        }
    }

    protected Plugin loadPlugin(KnowledgeBasePluginStub pluginStub) {
        KnowledgeBaseInterpreter interpreter = null;
        try {
            KnowledgeBase knowledgeBase = pluginStub.getKnowledgeBaseName() != null ? this.getEngine().getKnowledgeBaseManager().getKnowledgeBase(pluginStub.getKnowledgeBaseName()) : this.getEngine().getKnowledgeBaseManager().getDefaultKnowledgeBase();
            interpreter = knowledgeBase.getInterpreter();
            Plugin plugin = interpreter.createPluginInstance(pluginStub.getPluginClassName());
            if (pluginStub.getName() != null) {
                plugin.setName(pluginStub.getName());
            }
            if (pluginStub.getDisplayName() != null) {
                plugin.setDisplayName(pluginStub.getDisplayName());
            }
            if (pluginStub.getDescription() != null) {
                plugin.setDescription(pluginStub.getDescription());
            }
            plugin.setEngine(this.getEngine());
            plugin.setKnowledgeBase(knowledgeBase);
            plugin.setConfiguration(pluginStub.getConfiguration(), true);
            return plugin;
        }
        catch (Throwable e) {
            throw SpongeUtils.wrapException(interpreter, e);
        }
    }

    @Override
    public void doStartup() {
        this.initPlugins();
        this.startupPlugins();
        this.definePluginVariables();
    }

    public void startupPlugins() {
        this.getPlugins().forEach(Manageable::startup);
    }

    protected void initPlugins() {
        this.getPlugins().forEach(plugin -> this.initPlugin((Plugin)plugin));
    }

    protected void initPlugin(Plugin plugin) {
        if (plugin instanceof KnowledgeBasePluginStub) {
            KnowledgeBasePluginStub stub = (KnowledgeBasePluginStub)plugin;
            plugin = this.loadPlugin(stub);
            this.replacePlugin(stub, plugin);
        } else if (plugin.getKnowledgeBase() == null) {
            plugin.setKnowledgeBase(this.getEngine().getKnowledgeBaseManager().getDefaultKnowledgeBase());
        }
        plugin.onInit();
    }

    public void definePluginVariables() {
        this.getPlugins().forEach(plugin -> this.definePluginVariable(plugin.getName(), (Plugin)plugin));
    }

    protected void definePluginVariable(String name, Plugin plugin) {
        if (name != null) {
            this.getEngine().getKnowledgeBaseManager().setInterpreterGlobalVariable(name, (Object)plugin);
        }
    }

    protected void replacePlugin(KnowledgeBasePluginStub stub, Plugin plugin) {
        this.pluginMap.put(plugin.getName(), plugin);
    }

    @Override
    public void doShutdown() {
        this.getPlugins().forEach(plugin -> plugin.shutdown());
    }

    public void onBeforeReload() {
        this.getPlugins().forEach(plugin -> plugin.onBeforeReload());
    }

    public void onAfterReload() {
        this.definePluginVariables();
        this.getPlugins().forEach(plugin -> plugin.onAfterReload());
    }
}

