/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.kb;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.openksavi.sponge.core.kb.ScriptClassInstanceProvider;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.shaded.com.google.common.cache.CacheBuilder;
import org.openksavi.sponge.shaded.com.google.common.cache.CacheLoader;
import org.openksavi.sponge.shaded.com.google.common.cache.LoadingCache;

public class CachedScriptClassInstancePovider<S, T>
implements ScriptClassInstanceProvider<T> {
    private Function<String, S> createScriptFunction;
    private String format;
    private BiFunction<S, Class<T>, T> createInstanceFunction;
    private LoadingCache<String, S> cache;

    public CachedScriptClassInstancePovider(SpongeEngine engine, Function<String, S> createScriptFunction, String format, BiFunction<S, Class<T>, T> createInstanceFunction) {
        this.createScriptFunction = createScriptFunction;
        this.format = format;
        this.createInstanceFunction = createInstanceFunction;
        long cacheExpireTime = engine.getDefaultParameters().getScriptClassInstancePoviderCacheExpireTime();
        if (cacheExpireTime >= 0L) {
            CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder();
            if (cacheExpireTime > 0L) {
                builder.expireAfterAccess(cacheExpireTime, TimeUnit.MILLISECONDS);
            }
            this.cache = builder.build(new CacheLoader<String, S>(){

                @Override
                public S load(String className) throws Exception {
                    return CachedScriptClassInstancePovider.this.createScript(className);
                }
            });
        }
    }

    @Override
    public T newInstance(String className, Class<T> javaClass) {
        try {
            return this.createInstanceFunction.apply(this.cache != null ? this.cache.get(className) : this.createScript(className), javaClass);
        }
        catch (ExecutionException e) {
            throw SpongeUtils.wrapException(e.getCause() != null ? e.getCause() : e);
        }
        catch (Exception e) {
            throw SpongeUtils.wrapException(this.getClass().getSimpleName(), (Throwable)e);
        }
    }

    @Override
    public void clear() {
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
    }

    protected S createScript(String className) {
        return this.createScriptFunction.apply(String.format(this.format, className));
    }
}

