/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.kb;

import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.kb.BaseScriptKnowledgeBaseInterpreter;
import org.openksavi.sponge.core.kb.CachedScriptClassInstancePovider;
import org.openksavi.sponge.core.kb.ScriptClassInstanceProvider;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.kb.KnowledgeBaseEngineOperations;
import org.openksavi.sponge.kb.KnowledgeBaseType;

public abstract class EngineScriptKnowledgeBaseInterpreter
extends BaseScriptKnowledgeBaseInterpreter {
    private ScriptEngine scriptEngine;

    protected EngineScriptKnowledgeBaseInterpreter(KnowledgeBaseEngineOperations engineOperations, KnowledgeBaseType type) {
        super(engineOperations, type);
    }

    protected abstract String getScriptClassInstancePoviderFormat();

    protected abstract ScriptEngine createScriptEngine();

    @Override
    protected void prepareInterpreter() {
        this.scriptEngine = this.createScriptEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClear() {
        Object object = this.interpteterSynchro;
        synchronized (object) {
            this.invalidateCache();
            this.scriptEngine = null;
        }
    }

    protected Invocable getInvocable() {
        return (Invocable)((Object)this.scriptEngine);
    }

    public <T> T invokeOptionalFunction(String name, T defaultValue) {
        try {
            return (T)this.getInvocable().invokeFunction(name, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return defaultValue;
        }
        catch (ScriptException e) {
            throw SpongeUtils.wrapException(name, this, e);
        }
    }

    public <T> T invokeFunction(String name, Class<T> cls, Object ... args) {
        try {
            return (T)this.getInvocable().invokeFunction(name, args);
        }
        catch (NoSuchMethodException | ScriptException e) {
            throw SpongeUtils.wrapException(name, this, e);
        }
    }

    public Object invokeMethod(Object target, String name, Object ... args) {
        try {
            return this.getInvocable().invokeMethod(target, name, args);
        }
        catch (NoSuchMethodException | ScriptException e) {
            throw SpongeUtils.wrapInvokeException(target, name, this, e);
        }
    }

    public void setVariable(String name, Object value) {
        try {
            this.scriptEngine.put(name, value);
        }
        catch (Throwable e) {
            throw SpongeUtils.wrapException(this, e);
        }
    }

    public boolean existsVariable(String name) {
        try {
            return this.scriptEngine.getBindings(100).containsKey(name);
        }
        catch (Throwable e) {
            throw SpongeUtils.wrapException(this, e);
        }
    }

    public Object getVariable(String name) {
        if (!this.existsVariable(name)) {
            throw new SpongeException("Variable '" + name + "' not found");
        }
        try {
            return this.scriptEngine.get(name);
        }
        catch (Throwable e) {
            throw SpongeUtils.wrapException("getVariable", this, e);
        }
    }

    public <T> T eval(String expression) {
        try {
            return this.eval(this.scriptEngine, expression);
        }
        catch (Throwable e) {
            throw SpongeUtils.wrapException("eval", this, e);
        }
    }

    protected <T> T eval(ScriptEngine scriptEngine, String expression) {
        try {
            return (T)scriptEngine.eval(expression);
        }
        catch (Throwable e) {
            throw SpongeUtils.wrapException("eval", this, e);
        }
    }

    @Override
    public <T> T eval(Reader reader, String fileName) {
        try {
            return (T)this.scriptEngine.eval(reader);
        }
        catch (Throwable e) {
            throw SpongeUtils.wrapException(fileName, this, e);
        }
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public String resolveVariableName(Object value) {
        Bindings bindings = this.getScriptEngine().getBindings(100);
        Iterator iterator = bindings.entrySet().stream().filter(entry -> entry.getValue() == value).iterator();
        if (!iterator.hasNext()) {
            throw new SpongeException("Variable for processor " + value + " not found.");
        }
        Map.Entry variableEntry = (Map.Entry)iterator.next();
        if (iterator.hasNext()) {
            throw new SpongeException("Multiple variables for processor " + value + " have been found.");
        }
        return (String)variableEntry.getKey();
    }

    public boolean isKnowledgeBaseException(Throwable exception) {
        return SpongeUtils.containsException(exception, ScriptException.class);
    }

    public Throwable getJavaException(Throwable knowledgeBaseException) {
        return SpongeUtils.getException(knowledgeBaseException, ScriptException.class);
    }

    @Override
    protected <T> ScriptClassInstanceProvider<T> createScriptClassInstancePovider() {
        return new CachedScriptClassInstancePovider<CompiledScript, Object>(this.getEngineOperations().getEngine(), expression -> {
            try {
                return ((Compilable)((Object)this.scriptEngine)).compile((String)expression);
            }
            catch (ScriptException e) {
                throw SpongeUtils.wrapException(this, (Throwable)e);
            }
        }, this.getScriptClassInstancePoviderFormat(), (script, javaClass) -> {
            try {
                return script.eval();
            }
            catch (ScriptException e) {
                throw SpongeUtils.wrapException(this, (Throwable)e);
            }
        });
    }

    protected void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }
}

