/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.config;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.openksavi.sponge.config.Configuration;

public class CommonsConfiguration
implements Configuration {
    private BaseHierarchicalConfiguration config;

    public CommonsConfiguration(BaseHierarchicalConfiguration config) {
        this.config = config;
    }

    public BaseHierarchicalConfiguration getInternalConfiguration() {
        return this.config;
    }

    public void setVariables(Properties variables) {
        variables.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> this.config.setProperty((String)name, value)));
    }

    public void setVariable(String name, Object value) {
        this.config.setProperty(name, value);
    }

    public Object getVariable(String name) {
        return this.config.getProperty(name);
    }

    public String getName() {
        return this.config.getRootElementName();
    }

    public CommonsConfiguration getChildConfiguration(String child) {
        return new CommonsConfiguration((BaseHierarchicalConfiguration)(this.hasChildConfiguration(child) ? (BaseHierarchicalConfiguration)this.config.configurationAt(child) : new CombinedConfiguration()));
    }

    public boolean hasChildConfiguration(String key) {
        return !this.config.configurationsAt(key).isEmpty();
    }

    public CommonsConfiguration[] getChildConfigurationsOf(String key) {
        return this.createConfigurations(this.config.childConfigurationsAt(key));
    }

    public CommonsConfiguration[] getConfigurationsAt(String key) {
        return this.createConfigurations(this.config.configurationsAt(key));
    }

    protected CommonsConfiguration[] createConfigurations(List<HierarchicalConfiguration<ImmutableNode>> subs) {
        CommonsConfiguration[] result = new CommonsConfiguration[subs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new CommonsConfiguration((BaseHierarchicalConfiguration)subs.get(i));
        }
        return result;
    }

    public String getValue() {
        return this.config.getString(".");
    }

    public String getValue(String defaultValue) {
        return this.config.getString(".", defaultValue);
    }

    public String getString(String key, String defaultValue) {
        return this.config.getString(key, defaultValue);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.config.getInteger(key, defaultValue);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.config.getLong(key, defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.config.getBoolean(key, defaultValue);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return this.config.getByte(key, defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.config.getDouble(key, defaultValue);
    }

    public Float getFloat(String key, Float defaultValue) {
        return this.config.getFloat(key, defaultValue);
    }

    public Short getShort(String key, Short defaultValue) {
        return this.config.getShort(key, defaultValue);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.config.getBigDecimal(key, defaultValue);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.config.getBigInteger(key, defaultValue);
    }

    private String createAttributeKey(String name) {
        return "[@" + name + "]";
    }

    public String getAttribute(String name, String defaultValue) {
        return this.config.getString(this.createAttributeKey(name), defaultValue);
    }

    public Integer getIntegerAttribute(String name, Integer defaultValue) {
        return this.config.getInteger(this.createAttributeKey(name), defaultValue);
    }

    public Long getLongAttribute(String name, Long defaultValue) {
        return this.config.getLong(this.createAttributeKey(name), defaultValue);
    }

    public Boolean getBooleanAttribute(String name, Boolean defaultValue) {
        return this.config.getBoolean(this.createAttributeKey(name), defaultValue);
    }

    public Byte getByteAttribute(String name, Byte defaultValue) {
        return this.config.getByte(this.createAttributeKey(name), defaultValue);
    }

    public Double getDoubleAttribute(String name, Double defaultValue) {
        return this.config.getDouble(this.createAttributeKey(name), defaultValue);
    }

    public Float getFloatAttribute(String name, Float defaultValue) {
        return this.config.getFloat(this.createAttributeKey(name), defaultValue);
    }

    public Short getShortAttribute(String name, Short defaultValue) {
        return this.config.getShort(this.createAttributeKey(name), defaultValue);
    }

    public BigDecimal getBigDecimalAttribute(String name, BigDecimal defaultValue) {
        return this.config.getBigDecimal(this.createAttributeKey(name), defaultValue);
    }

    public BigInteger getBigIntegerAttribute(String name, BigInteger defaultValue) {
        return this.config.getBigInteger(this.createAttributeKey(name), defaultValue);
    }

    public String toString() {
        return this.config.getRootElementName();
    }
}

