/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine.event;

import org.openksavi.sponge.core.engine.event.BaseEventQueue;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.QueueFullException;
import org.openksavi.sponge.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullEventQueue
extends BaseEventQueue {
    private static final Logger ignoredEventsLogger = LoggerFactory.getLogger((String)"sponge.event.ignored");

    public NullEventQueue() {
        super("NullEventQueue");
    }

    public void put(Event event) throws QueueFullException {
        if (ignoredEventsLogger.isInfoEnabled() && !SpongeUtils.isSystemEvent(event)) {
            ignoredEventsLogger.info("Ignored event: {}", (Object)event);
        }
    }

    public Event get(long timeout) throws InterruptedException {
        return null;
    }

    @Override
    public void setCapacity(int capacity) {
    }

    @Override
    public int getCapacity() {
        return -1;
    }

    public void clear() {
    }

    public int getSize() {
        return 0;
    }
}

