/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine.interactive;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.engine.GenericExceptionContext;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.ExceptionContext;
import org.openksavi.sponge.engine.ExceptionHandler;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.engine.interactive.InteractiveMode;
import org.openksavi.sponge.engine.interactive.InteractiveModeConsole;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseInterpreter;
import org.openksavi.sponge.kb.ScriptKnowledgeBaseInterpreter;

public class DefaultInteractiveMode
implements InteractiveMode {
    protected SpongeEngine engine;
    protected String kbName;
    private ExceptionHandler exceptionHandler;
    private Supplier<InteractiveModeConsole> consoleSupplier;
    private InteractiveModeConsole activeConsole;
    private AtomicBoolean running = new AtomicBoolean(false);

    public DefaultInteractiveMode(SpongeEngine engine, String kbName, Supplier<InteractiveModeConsole> consoleSupplier) {
        this.engine = engine;
        this.kbName = kbName;
        this.consoleSupplier = consoleSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop() {
        this.running.set(true);
        try (InteractiveModeConsole console = this.consoleSupplier.get();){
            this.activeConsole = console;
            if (!console.isOpen()) {
                console.open();
            }
            ScriptKnowledgeBaseInterpreter scriptInterpreter = this.getScriptKnowledgeBaseInterpreter();
            console.print(this.getWelcomeMessage());
            while (true) {
                try {
                    while (this.iteration(console, scriptInterpreter)) {
                    }
                }
                catch (Throwable e) {
                    this.handleException("interactive", e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.running.set(false);
        }
    }

    protected boolean iteration(InteractiveModeConsole reader, ScriptKnowledgeBaseInterpreter scriptInterpreter) throws IOException {
        StringBuffer commandBuffer = new StringBuffer();
        while (true) {
            if (!this.engine.isRunning()) {
                return false;
            }
            String command = null;
            try {
                command = reader.readLine();
            }
            catch (IOException e) {
                this.handleException("readLine", e);
                return false;
            }
            if (command == null) {
                return false;
            }
            command = StringUtils.stripEnd((String)command, null);
            if (StringUtils.equalsAny((CharSequence)command.trim(), (CharSequence[])new CharSequence[]{"exit", "quit"})) {
                return false;
            }
            boolean isMultiLineStatement = command.endsWith("\\");
            if (isMultiLineStatement) {
                command = StringUtils.removeEnd((String)command, (String)"\\");
            }
            commandBuffer.append(command);
            if (!isMultiLineStatement) break;
            commandBuffer.append(System.lineSeparator());
        }
        if (this.engine.isRunning()) {
            scriptInterpreter.eval(commandBuffer.toString());
            return true;
        }
        return false;
    }

    protected void handleException(String sourceName, Throwable e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handleException(e, (ExceptionContext)new GenericExceptionContext(this.engine, (String)ObjectUtils.defaultIfNull((Object)SpongeUtils.getSourceName(e), (Object)sourceName)));
        } else {
            e.printStackTrace();
        }
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected ScriptKnowledgeBaseInterpreter getScriptKnowledgeBaseInterpreter() {
        KnowledgeBase knowledgeBase = this.kbName != null ? this.engine.getKnowledgeBaseManager().getKnowledgeBase(this.kbName) : this.engine.getKnowledgeBaseManager().getMainKnowledgeBase();
        KnowledgeBaseInterpreter interpreter = knowledgeBase.getInterpreter();
        if (!(interpreter instanceof ScriptKnowledgeBaseInterpreter)) {
            throw new SpongeException("Knowledge base '" + this.kbName + "' is not script-based.");
        }
        return (ScriptKnowledgeBaseInterpreter)interpreter;
    }

    protected String getWelcomeMessage() {
        return "Running " + this.engine.getInfo() + " in the interactive mode. Type \"" + "exit" + "\", \"" + "quit" + "\" or press CTRL-D to exit.\n";
    }

    public InteractiveModeConsole getConsole() {
        return this.activeConsole;
    }

    public boolean isRunning() {
        return this.running.get();
    }
}

