/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.rule;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.rule.AbstractRuleAdapter;
import org.openksavi.sponge.core.rule.BaseRuleDefinition;
import org.openksavi.sponge.core.rule.OrderedRuleAdapterRuntime;
import org.openksavi.sponge.core.rule.RuleAdapterRuntime;
import org.openksavi.sponge.core.rule.UnorderedRuleAdapterRuntime;
import org.openksavi.sponge.core.util.Tree;
import org.openksavi.sponge.engine.ProcessorType;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.rule.Rule;

public class BaseRuleAdapter
extends AbstractRuleAdapter<Rule> {
    private RuleAdapterRuntime runtime;

    public BaseRuleAdapter(BaseRuleDefinition definition) {
        super(definition);
    }

    public ProcessorType getType() {
        return ProcessorType.RULE;
    }

    @Override
    public void onEvent(Event event) {
        this.lock.lock();
        try {
            this.runtime.onEvent(event);
        }
        finally {
            this.lock.unlock();
        }
    }

    public SpongeException createValidationException(String text) {
        return new SpongeException("Invalid rule " + this.getName() + ". " + text);
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.runtime.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public RuleAdapterRuntime getRuntime() {
        if (this.runtime == null) {
            this.runtime = this.getDefinition().isOrdered() ? new OrderedRuleAdapterRuntime(this) : new UnorderedRuleAdapterRuntime(this);
        }
        return this.runtime;
    }

    public boolean acceptAsFirst(Event event) {
        return this.getRuntime().acceptAsFirst(event);
    }

    @Override
    protected boolean runRule() {
        return this.getRuntime().runRule();
    }

    @Override
    public boolean isCandidateForFirstEvent(Event event) {
        return this.getRuntime().isCandidateForFirstEvent(event);
    }

    @Override
    public Event getFirstEvent() {
        return this.getRuntime().getFirstEvent();
    }

    public Event getEvent(String eventAlias) {
        return this.getRuntime().getEvent(eventAlias);
    }

    public final Map<String, Event> getEventAliasMap() {
        return this.getRuntime().getEventAliasMap();
    }

    public final List<Event> getEventSequence() {
        return this.getRuntime().getEventSequence();
    }

    public final Tree<RuleAdapterRuntime.NodeValue> getEventTree() {
        return this.getRuntime().getEventTree();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getEventModes() == null || this.getEventModes().length < 1) {
            throw this.createValidationException("Event modes are not specified.");
        }
        if (this.getEventNames().length != this.getEventModes().length) {
            throw this.createValidationException("Each event should have a mode specified (explicitly or implicitly).");
        }
        if (Arrays.stream(this.getEventAliases()).distinct().count() < (long)this.getEventAliases().length) {
            throw this.createValidationException("Event aliases/names must be unique.");
        }
        Set eventAliasesSet = Arrays.stream(this.getEventAliases()).collect(Collectors.toSet());
        for (String alias : this.getEventConditions().keySet()) {
            if (eventAliasesSet.contains(alias)) continue;
            throw this.createValidationException("Condition event alias '" + alias + "' does not exist");
        }
        this.getRuntime().validate();
    }
}

