/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class ServiceLoaderUtils {
    public static <T> T loadService(Class<T> serviceClass) {
        return ServiceLoaderUtils.loadService(serviceClass, false);
    }

    public static <T> T loadService(Class<T> serviceClass, boolean required) {
        List<T> result = ServiceLoaderUtils.loadServices(serviceClass);
        if (result.isEmpty()) {
            if (required) {
                throw new IllegalArgumentException("No ServiceLoader configuration for " + serviceClass.getName() + " has been found");
            }
            return null;
        }
        if (result.size() > 1) {
            throw new IllegalArgumentException("More than one ServiceLoader configuration for " + serviceClass.getName() + " has been found");
        }
        return result.get(0);
    }

    public static <T> List<T> loadServices(Class<T> serviceClass) {
        Iterator<T> iterator = ServiceLoader.load(serviceClass).iterator();
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }
}

