/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TreeNode<T> {
    private static final int TREE_INDENT = 4;
    protected T value;
    protected TreeNode<T> parent;
    protected List<TreeNode<T>> children = new ArrayList<TreeNode<T>>();
    protected int level = 0;

    public TreeNode() {
    }

    public TreeNode(T value) {
        this.value = value;
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public T getValue() {
        return this.value;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public void addChild(TreeNode<T> node) {
        this.children.add(node);
        node.parent = this;
        node.level = this.level + 1;
    }

    public void removeChild(TreeNode<T> node) {
        this.children.remove(node);
        if (node.parent == this) {
            node.parent = null;
            node.level = 0;
        }
    }

    public void removeChild(int index, TreeNode<T> node) {
        this.children.remove(index);
        if (node.parent == this) {
            node.parent = null;
            node.level = 0;
        }
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    public void setValue(T value) {
        this.value = value;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        return this.toString(0, new StringBuilder(this.level * 128)).toString();
    }

    private StringBuilder toString(int level, StringBuilder s) {
        s.append("\n" + StringUtils.repeat((char)' ', (int)(level * 4)) + this.value);
        this.children.forEach(node -> node.toString(level + 1, s));
        return s;
    }

    public List<T> getPathValues(TreeNode<T> node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<T> path = new ArrayList<T>(node.level + 1);
        for (TreeNode<T> n = node; n != null; n = n.getParent()) {
            path.add(n.getValue());
        }
        Collections.reverse(path);
        return path;
    }

    public List<TreeNode<T>> getPath(TreeNode<T> node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<TreeNode<T>> path = new ArrayList<TreeNode<T>>(node.level + 1);
        for (TreeNode<T> n = node; n != null; n = n.getParent()) {
            path.add(n);
        }
        Collections.reverse(path);
        return path;
    }
}

