/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.java;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.ClassUtils;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.core.kb.BaseNonScriptKnowledgeBase;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.java.core.JavaConstants;
import org.openksavi.sponge.java.core.JavaKnowledgeBaseEngineOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JKnowledgeBase
extends BaseNonScriptKnowledgeBase {
    private static final Logger logger = LoggerFactory.getLogger(JKnowledgeBase.class);

    protected JKnowledgeBase(String name) {
        super(name, JavaConstants.TYPE);
    }

    protected JKnowledgeBase() {
        super(JavaConstants.TYPE);
    }

    @Override
    public JavaKnowledgeBaseEngineOperations getEngineOperations() {
        return (JavaKnowledgeBaseEngineOperations)super.getEngineOperations();
    }

    @Override
    public JavaKnowledgeBaseEngineOperations getEps() {
        return this.getEngineOperations();
    }

    public void scanToAutoEnable() {
        ArrayList autoEnabled = new ArrayList();
        Arrays.stream(this.getClass().getDeclaredClasses()).filter(cls -> !SpongeUtils.isAbstract(cls)).forEachOrdered(cls -> {
            if (JavaConstants.PROCESSOR_CLASSES.values().stream().filter(processorClass -> ClassUtils.isAssignable((Class)cls, (Class)processorClass)).findFirst().isPresent()) {
                autoEnabled.add(cls.getName());
                this.getEngineOperations().enableJava((Class<? extends Processor>)cls);
            }
        });
        if (logger.isDebugEnabled() && !autoEnabled.isEmpty()) {
            logger.debug("Auto-enabling: {}", autoEnabled);
        }
    }
}

