/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openksavi.sponge.EventSetProcessor;
import org.openksavi.sponge.EventSetProcessorAdapter;
import org.openksavi.sponge.EventSetProcessorAdapterGroup;
import org.openksavi.sponge.EventSetProcessorState;
import org.openksavi.sponge.core.BaseEventProcessorAdapter;
import org.openksavi.sponge.core.BaseEventSetProcessorDefinition;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEventSetProcessorAdapter<T extends EventSetProcessor<?>>
extends BaseEventProcessorAdapter<T>
implements EventSetProcessorAdapter<T> {
    private static final Logger logger = LoggerFactory.getLogger(BaseEventSetProcessorAdapter.class);
    private AtomicReference<EventSetProcessorState> state = new AtomicReference<EventSetProcessorState>(EventSetProcessorState.CREATED);
    protected AtomicBoolean durationTriggered = new AtomicBoolean(false);
    protected EventSetProcessorAdapterGroup<EventSetProcessorAdapter<?>> group;
    protected Lock lock = new ReentrantLock(true);

    protected BaseEventSetProcessorAdapter(BaseEventSetProcessorDefinition definition) {
        super(definition);
    }

    @Override
    public BaseEventSetProcessorDefinition getDefinition() {
        return (BaseEventSetProcessorDefinition)super.getDefinition();
    }

    public void setState(EventSetProcessorState state) {
        this.state.set(state);
    }

    public EventSetProcessorState getState() {
        return this.state.get();
    }

    public boolean isRunning() {
        return this.state.get() == EventSetProcessorState.RUNNING;
    }

    public EventSetProcessorAdapterGroup<EventSetProcessorAdapter<?>> getGroup() {
        return this.group;
    }

    public void setGroup(EventSetProcessorAdapterGroup<? extends EventSetProcessorAdapter<?>> group) {
        this.group = group;
    }

    public void finish() {
        this.lock.lock();
        try {
            if (this.getState() != EventSetProcessorState.FINISHED) {
                this.setState(EventSetProcessorState.FINISHED);
                this.group.removeDuration((EventSetProcessorAdapter)this);
                this.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public final void processEvent(Event event) {
        try {
            this.onEvent(event);
        }
        catch (Throwable e) {
            throw SpongeUtils.wrapException(this.getProcessor(), e);
        }
    }

    protected abstract void onEvent(Event var1);

    public final void durationOccurred() {
        logger.debug("{} - Duration occurred", (Object)this.getName());
        this.lock.lock();
        try {
            if (this.isRunning()) {
                this.setDurationTriggered(true);
                this.onDuration();
                this.finish();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void onDuration();

    public boolean hasDuration() {
        return this.getDefinition().hasDuration();
    }

    public void setDuration(Duration duration) {
        this.getDefinition().setDuration(duration);
    }

    public Duration getDuration() {
        return this.getDefinition().getDuration();
    }

    public Boolean isSynchronous() {
        return this.getDefinition().isSynchronous();
    }

    public void setSynchronous(Boolean synchronous) {
        this.getDefinition().setSynchronous(synchronous);
    }

    public boolean isDurationTriggered() {
        return this.durationTriggered.get();
    }

    public void setDurationTriggered(boolean durationTriggered) {
        this.durationTriggered.set(durationTriggered);
    }

    public abstract boolean isCandidateForFirstEvent(Event var1);

    public abstract Event getFirstEvent();
}

