/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core;

import java.util.Map;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.ProcessorAdapter;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.BaseProcessor;
import org.openksavi.sponge.core.BaseProcessorDefinition;
import org.openksavi.sponge.core.ProcessorAdapterImplementor;
import org.openksavi.sponge.core.kb.BaseKnowledgeBase;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseProcessorAdapter<T extends Processor<?>>
implements ProcessorAdapter<T>,
ProcessorAdapterImplementor,
Cloneable {
    private BaseProcessorDefinition definition;
    private T processor;

    protected BaseProcessorAdapter(BaseProcessorDefinition definition) {
        this.definition = definition;
    }

    public T getProcessor() {
        return this.processor;
    }

    public void setProcessor(T processor) {
        this.processor = processor;
        BaseProcessor processorImpl = (BaseProcessor)processor;
        if (processorImpl.getAdapter() == null) {
            processorImpl.setAdapter(this);
        }
    }

    @Override
    public void setDefinition(BaseProcessorDefinition definition) {
        if (this.definition != null) {
            return;
        }
        this.definition = definition;
    }

    @Override
    public BaseProcessorDefinition getDefinition() {
        return this.definition;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.definition.getKnowledgeBase();
    }

    @Override
    public void setKnowledgeBase(BaseKnowledgeBase knowledgeBase) {
        this.definition.setKnowledgeBase(knowledgeBase);
    }

    public Map<String, Object> getMeta() {
        return this.definition.getMeta();
    }

    public void setMeta(Map<String, Object> meta) {
        this.definition.setMeta(meta);
    }

    public String getName() {
        return this.definition.getName();
    }

    public void setName(String name) {
        this.definition.setName(name);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw SpongeUtils.wrapException(this.getName(), (Throwable)e);
        }
    }

    public void clear() {
    }

    public void setDisplayName(String displayName) {
        this.definition.setDisplayName(displayName);
    }

    public String getDisplayName() {
        return this.definition.getDisplayName();
    }

    public void setDescription(String description) {
        this.definition.setDescription(description);
    }

    public String getDescription() {
        return this.definition.getDescription();
    }

    @Override
    public boolean isJavaDefined() {
        return this.definition.isJavaDefined();
    }

    public Logger getLogger() {
        return LoggerFactory.getLogger((String)SpongeUtils.createLoggerName(this.getKnowledgeBase(), this.getName()));
    }

    public String toString() {
        return this.getName() != null ? this.getName() : super.toString();
    }

    public void validate() {
        if (this.getName() == null) {
            throw new SpongeException("Invalid " + this.getType().getName() + ". Name must not be empty.");
        }
    }
}

