/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.ProcessorNotFoundException;
import org.openksavi.sponge.action.ActionAdapter;
import org.openksavi.sponge.core.BaseProcessorDefinition;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.ActionManager;
import org.openksavi.sponge.engine.ProcessorType;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBaseInterpreter;

public class DefaultActionManager
extends BaseEngineModule
implements ActionManager {
    private Map<String, ActionAdapter> registeredActions = Collections.synchronizedMap(new LinkedHashMap());

    public DefaultActionManager(SpongeEngine engine) {
        super("ActionManager", engine);
    }

    public void addAction(ActionAdapter actionAdapter) {
        Validate.notNull((Object)actionAdapter, (String)"addAction called with null actionAdapter.", (Object[])new Object[0]);
        this.registeredActions.put(actionAdapter.getName(), actionAdapter);
    }

    public void removeAction(String actionName) {
        Validate.notNull((Object)actionName, (String)"removeAction called with null action name.", (Object[])new Object[0]);
        this.registeredActions.remove(actionName);
    }

    public Object callAction(String actionName, Object[] args) {
        ActionAdapter action = this.registeredActions.get(actionName);
        if (action == null) {
            throw new ProcessorNotFoundException(ProcessorType.ACTION, actionName);
        }
        KnowledgeBaseInterpreter interpreter = ((BaseProcessorDefinition)action.getDefinition()).isJavaDefined() ? this.getEngine().getKnowledgeBaseManager().getDefaultKnowledgeBase().getInterpreter() : action.getKnowledgeBase().getInterpreter();
        try {
            return interpreter.invokeMethod((Object)action.getProcessor(), "onCall", args != null ? args : new Object[]{});
        }
        catch (Throwable e) {
            throw SpongeUtils.wrapException(action.getProcessor(), e);
        }
    }

    public Map<String, ActionAdapter> getRegisteredActionAdapterMap() {
        return this.registeredActions;
    }

    public boolean existsAction(String name) {
        return this.registeredActions.containsKey(name);
    }

    public ActionAdapter getActionAdapter(String actionName) {
        return this.registeredActions.get(actionName);
    }

    public List<ActionAdapter> getActionAdapters(String knowledgeBaseRegexp, String actionNameRegexp) {
        return this.registeredActions.values().stream().filter(adapter -> !(knowledgeBaseRegexp != null && !adapter.getKnowledgeBase().getName().matches(knowledgeBaseRegexp) || actionNameRegexp != null && !adapter.getName().matches(actionNameRegexp))).collect(Collectors.toList());
    }
}

