/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.resolver.DefaultEntityResolver;
import org.apache.commons.configuration2.tree.MergeCombiner;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.openksavi.sponge.config.ConfigException;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.config.PropertyEntry;
import org.openksavi.sponge.core.config.CommonsConfiguration;
import org.openksavi.sponge.core.config.FallbackBasePathLocationStrategy;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.engine.GenericPropertyEntry;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.ConfigurationManager;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.event.EventClonePolicy;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultConfigurationManager
extends BaseEngineModule
implements ConfigurationManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConfigurationManager.class);
    private String configurationFilename;
    private String home;
    private URL configurationFileUrl;
    private String engineName;
    private String engineDisplayName;
    private String engineDescription;
    private CommonsConfiguration rootConfig;
    private CommonsConfiguration engineConfig;
    private Integer mainProcessingUnitThreadCount;
    private EventClonePolicy eventClonePolicy;
    private Integer eventQueueCapacity;
    private Integer durationThreadCount;
    private Integer asyncEventSetProcessorExecutorThreadCount;
    private Boolean eventSetProcessorDefaultSynchronous;
    private Boolean autoEnable;
    private Long executorShutdownTimeout;
    private Map<String, PropertyEntry> properties = new LinkedHashMap<String, PropertyEntry>();
    protected List<Plugin> preConfigPlugins = new ArrayList<Plugin>();
    protected List<Plugin> postConfigPlugins = new ArrayList<Plugin>();
    protected List<KnowledgeBase> preConfigKnowledgeBases = new ArrayList<KnowledgeBase>();
    protected List<KnowledgeBase> postConfigKnowledgeBases = new ArrayList<KnowledgeBase>();

    public DefaultConfigurationManager(SpongeEngine engine, String configurationFilename) {
        super("ConfigurationManager", engine);
        this.configurationFilename = configurationFilename;
    }

    @Override
    public void doStartup() {
        this.home = System.getProperty("sponge.home");
        this.setupRootConfig();
        this.setupPredefinedProperties();
        this.rootConfig.setVariables(System.getProperties());
        this.setupXmlProperties();
        this.applySystemProperties();
        this.applyVariableProperties();
        this.engineConfig = this.rootConfig.getChildConfiguration("engine");
        this.engineName = this.engineConfig.getAttribute("name", null);
        this.engineDisplayName = this.engineConfig.getAttribute("displayName", null);
        this.engineDescription = this.engineConfig.getString("description", null);
        this.setupEngineParameters();
        if (this.home == null) {
            this.home = this.getProperty("sponge.home");
        }
        logger.debug(this.toString());
    }

    private void setupEngineParameters() {
        if (this.mainProcessingUnitThreadCount == null) {
            this.mainProcessingUnitThreadCount = this.engineConfig.getInteger("mainProcessingUnitThreadCount", this.getEngine().getDefaultParameters().getMainProcessingUnitThreadCount());
        }
        if (this.eventClonePolicy == null) {
            this.eventClonePolicy = EventClonePolicy.valueOf((String)this.engineConfig.getString("eventClonePolicy", this.getEngine().getDefaultParameters().getEventClonePolicy().name()).toUpperCase());
        }
        if (this.eventQueueCapacity == null) {
            this.eventQueueCapacity = this.engineConfig.getInteger("eventQueueCapacity", this.getEngine().getDefaultParameters().getEventQueueCapacity());
        }
        if (this.durationThreadCount == null) {
            this.durationThreadCount = this.engineConfig.getInteger("durationThreadCount", this.getEngine().getDefaultParameters().getDurationThreadCount());
        }
        if (this.asyncEventSetProcessorExecutorThreadCount == null) {
            this.asyncEventSetProcessorExecutorThreadCount = this.engineConfig.getInteger("asyncEventSetProcessorExecutorThreadCount", this.getEngine().getDefaultParameters().getAsyncEventSetProcessorExecutorThreadCount());
        }
        if (this.eventSetProcessorDefaultSynchronous == null) {
            this.eventSetProcessorDefaultSynchronous = this.engineConfig.getBoolean("eventSetProcessorDefaultSynchronous", this.getEngine().getDefaultParameters().getEventSetProcessorDefaultSynchronous());
        }
        if (this.autoEnable == null) {
            this.autoEnable = this.engineConfig.getBoolean("autoEnable", this.getEngine().getDefaultParameters().getAutoEnable());
        }
        if (this.executorShutdownTimeout == null) {
            this.executorShutdownTimeout = this.engineConfig.getLong("executorShutdownTimeout", this.getEngine().getDefaultParameters().getExecutorShutdownTimeout());
        }
    }

    private void setupPredefinedProperties() {
        this.properties.forEach((name, entry) -> {
            Object value = entry.getValue();
            if (value != null) {
                this.rootConfig.setVariable((String)name, value);
            }
        });
    }

    private void applySystemProperties() {
        this.properties.forEach((name, entry) -> {
            Object value = entry.getValue();
            if (entry.isSystem() && value != null) {
                String alreadySetValue = System.getProperty(name);
                System.setProperty(name, value.toString());
                if (alreadySetValue != null && !alreadySetValue.equals(value)) {
                    logger.debug("Overriding already set system property {} to {} (previous value was {})", new Object[]{name, value, alreadySetValue});
                }
            }
        });
    }

    private void applyVariableProperties() {
        this.properties.forEach((name, entry) -> {
            if (entry.isVariable()) {
                this.getEngine().getOperations().setVariable(name, entry.getValue());
            }
        });
    }

    private void setupXmlProperties() {
        for (CommonsConfiguration configuration : this.rootConfig.getChildConfigurationsOf("properties")) {
            String name = configuration.getAttribute("name", null);
            Object value = configuration.getValue();
            String systemProperty = System.getProperty(name);
            PropertyEntry entry = this.properties.get(name);
            if (systemProperty != null) {
                value = systemProperty;
            } else if (entry == null) {
                this.properties.put(name, new GenericPropertyEntry(value, this.isPropertyVariable(configuration), this.isPropertySystem(configuration)));
            } else {
                value = entry.getValue();
            }
            this.rootConfig.setVariable(name, value);
        }
    }

    protected Pair<XMLConfiguration, URL> createXmlConfiguration(String fileName) {
        FallbackBasePathLocationStrategy locationStrategy = new FallbackBasePathLocationStrategy(FileLocatorUtils.DEFAULT_LOCATION_STRATEGY, this.home);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)new Parameters().xml().setLocationStrategy((FileLocationStrategy)locationStrategy)).setFileName(fileName)).setSchemaValidation(true)).setEntityResolver((EntityResolver)((Object)new ResourceSchemaResolver()))});
        try {
            XMLConfiguration xmlConfiguration = (XMLConfiguration)builder.getConfiguration();
            return new ImmutablePair((Object)xmlConfiguration, (Object)locationStrategy.getLocatedUrl());
        }
        catch (ConfigurationException e) {
            throw new ConfigException("Error reading configuration file " + fileName, (Throwable)e);
        }
    }

    protected void setupRootConfig() {
        MergeCombiner combiner = new MergeCombiner();
        combiner.addListNode("plugin");
        CombinedConfiguration cc = new CombinedConfiguration((NodeCombiner)combiner);
        if (this.configurationFilename != null) {
            logger.info("Loading configuration file {}...", (Object)this.configurationFilename);
            Pair<XMLConfiguration, URL> configurationPair = this.createXmlConfiguration(this.configurationFilename);
            XMLConfiguration fileConfiguration = (XMLConfiguration)configurationPair.getLeft();
            this.configurationFileUrl = (URL)configurationPair.getRight();
            cc.addConfiguration((org.apache.commons.configuration2.Configuration)fileConfiguration);
            fileConfiguration.setProperty("sponge.configDir", (Object)SpongeUtils.getFileDir(this.configurationFileUrl));
        }
        cc.addConfiguration((org.apache.commons.configuration2.Configuration)this.createXmlConfiguration("org/openksavi/sponge/config/defaultConfiguration.xml").getLeft());
        if (this.configurationFilename != null && logger.isDebugEnabled()) {
            logger.debug("Initial XML configuration:\n{}", (Object)SpongeUtils.dumpConfiguration((org.apache.commons.configuration2.Configuration)cc));
        }
        this.rootConfig = new CommonsConfiguration((BaseHierarchicalConfiguration)cc);
    }

    private boolean isPropertySystem(Configuration configuration) {
        return configuration.getBooleanAttribute("system", Boolean.valueOf(false));
    }

    private boolean isPropertyVariable(Configuration configuration) {
        return configuration.getBooleanAttribute("variable", Boolean.valueOf(false));
    }

    public Configuration getRootConfig() {
        return this.rootConfig;
    }

    public Configuration getEngineConfig() {
        return this.engineConfig;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getEngineDisplayName() {
        return this.engineDisplayName;
    }

    public void setEngineDisplayName(String engineDisplayName) {
        this.engineDisplayName = engineDisplayName;
    }

    public String getEngineDescription() {
        return this.engineDescription;
    }

    public void setEngineDescription(String engineDescription) {
        this.engineDescription = engineDescription;
    }

    public int getMainProcessingUnitThreadCount() {
        return this.mainProcessingUnitThreadCount;
    }

    public int getEventQueueCapacity() {
        return this.eventQueueCapacity;
    }

    public int getDurationThreadCount() {
        return this.durationThreadCount;
    }

    public int getAsyncEventSetProcessorExecutorThreadCount() {
        return this.asyncEventSetProcessorExecutorThreadCount;
    }

    public EventClonePolicy getEventClonePolicy() {
        return this.eventClonePolicy;
    }

    public long getExecutorShutdownTimeout() {
        return this.executorShutdownTimeout;
    }

    public String getHome() {
        return this.home;
    }

    public URL getConfigurationFileUrl() {
        return this.configurationFileUrl;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("home", (Object)this.home).append("configurationFilename", (Object)this.configurationFilename).append("configurationFileUrl", (Object)this.configurationFileUrl).append("engineName", (Object)this.engineName).append("mainProcessingUnitThreadCount", (Object)this.mainProcessingUnitThreadCount).append("asyncEventSetProcessorExecutorThreadCount", (Object)this.asyncEventSetProcessorExecutorThreadCount).append("eventQueueCapacity", (Object)this.eventQueueCapacity).append("eventSetProcessorDefaultSynchronous", (Object)this.eventSetProcessorDefaultSynchronous).append("eventClonePolicy", (Object)this.eventClonePolicy).append("autoEnable", (Object)this.autoEnable).append("durationThreadCount", (Object)this.durationThreadCount).append("executorShutdownTimeout", (Object)this.executorShutdownTimeout).append("properties", this.properties).toString();
    }

    public String getProperty(String name) {
        String systemProperty = System.getProperty(name);
        if (systemProperty != null) {
            return systemProperty;
        }
        PropertyEntry entry = this.properties.get(name);
        if (entry == null) {
            return null;
        }
        Object value = entry.getValue();
        return value != null ? String.valueOf(value) : null;
    }

    public void setEventClonePolicy(EventClonePolicy eventClonePolicy) {
        this.eventClonePolicy = eventClonePolicy;
    }

    public void setMainProcessingUnitThreadCount(int mainProcessingUnitThreadCount) {
        this.mainProcessingUnitThreadCount = mainProcessingUnitThreadCount;
    }

    public void setEventQueueCapacity(int eventQueueCapacity) {
        this.eventQueueCapacity = eventQueueCapacity;
    }

    public void setDurationThreadCount(int durationThreadCount) {
        this.durationThreadCount = durationThreadCount;
    }

    public void setAsyncEventSetProcessorExecutorThreadCount(int asyncEventSetProcessorExecutorThreadCount) {
        this.asyncEventSetProcessorExecutorThreadCount = asyncEventSetProcessorExecutorThreadCount;
    }

    public void setExecutorShutdownTimeout(long executorShutdownTimeout) {
        this.executorShutdownTimeout = executorShutdownTimeout;
    }

    public void setProperty(String key, Object value, boolean variable, boolean system) {
        this.properties.put(key, new GenericPropertyEntry(value, variable, system));
    }

    public void setProperty(String key, Object value) {
        this.setProperty(key, value, false, false);
    }

    public void setSystemProperty(String key, Object value) {
        this.setProperty(key, value, false, true);
    }

    public void setVariableProperty(String key, Object value) {
        this.setProperty(key, value, true, false);
    }

    public void setProperties(Map<String, Object> properties) {
        properties.forEach((key, value) -> this.setProperty((String)key, value));
    }

    public void setSystemProperties(Map<String, String> systemProperties) {
        systemProperties.forEach((key, value) -> this.setSystemProperty((String)key, value));
    }

    public void setVariableProperties(Map<String, String> variableProperties) {
        variableProperties.forEach((key, value) -> this.setVariableProperty((String)key, value));
    }

    public void setPropertyEntries(Map<String, PropertyEntry> propertyEntries) {
        this.properties.putAll(propertyEntries);
    }

    public boolean getEventSetProcessorDefaultSynchronous() {
        return this.eventSetProcessorDefaultSynchronous;
    }

    public void setEventSetProcessorDefaultSynchronous(boolean eventSetProcessorDefaultSynchronous) {
        this.eventSetProcessorDefaultSynchronous = eventSetProcessorDefaultSynchronous;
    }

    public boolean getAutoEnable() {
        return this.autoEnable;
    }

    public void setAutoEnable(boolean autoEnable) {
        this.autoEnable = autoEnable;
    }

    public List<Plugin> getPreConfigPlugins() {
        return this.preConfigPlugins;
    }

    public List<Plugin> getPostConfigPlugins() {
        return this.postConfigPlugins;
    }

    public void addPreConfigPlugins(List<Plugin> plugins) {
        this.preConfigPlugins.addAll(plugins);
    }

    public void addPostConfigPlugins(List<Plugin> plugins) {
        this.postConfigPlugins.addAll(plugins);
    }

    public List<KnowledgeBase> getPreConfigKnowledgeBases() {
        return this.preConfigKnowledgeBases;
    }

    public List<KnowledgeBase> getPostConfigKnowledgeBases() {
        return this.postConfigKnowledgeBases;
    }

    public void addPreConfigKnowledgeBases(List<KnowledgeBase> knowledgeBases) {
        this.preConfigKnowledgeBases.addAll(knowledgeBases);
    }

    public void addPostConfigKnowledgeBases(List<KnowledgeBase> knowledgeBases) {
        this.postConfigKnowledgeBases.addAll(knowledgeBases);
    }

    private static class ResourceSchemaResolver
    extends DefaultEntityResolver {
        private ResourceSchemaResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if ("http://sponge.openksavi.org/schema/config.xsd".equals(systemId)) {
                InputStream stream = ConfigurationManager.class.getResourceAsStream("/org/openksavi/sponge/schema/config.xsd");
                if (stream != null) {
                    InputSource source = new InputSource(stream);
                    source.setPublicId(publicId);
                    source.setSystemId(systemId);
                    return source;
                }
                throw new SAXException("Cannot find schema http://sponge.openksavi.org/schema/config.xsd");
            }
            return super.resolveEntity(publicId, systemId);
        }
    }
}

