/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;
import org.openksavi.sponge.engine.Variables;

public class MapVariables
implements Variables {
    private static final long serialVersionUID = 6240397591532960287L;
    private Map<String, Object> variables = Collections.synchronizedMap(new HashMap());

    private String normalizeName(String name) {
        return name.trim();
    }

    public void set(String name, Object value) {
        this.variables.put(this.normalizeName(name), value);
    }

    public Object get(String name) {
        return this.doGet(name, true);
    }

    public <T> T get(Class<T> cls, String name) {
        return (T)this.get(name);
    }

    public <T> T get(String name, T defaultValue) {
        return (T)ObjectUtils.defaultIfNull((Object)this.doGet(name, false), defaultValue);
    }

    public <T> T get(Class<T> cls, String name, T defaultValue) {
        return this.get(name, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doGet(String name, boolean required) {
        String normalizedName = this.normalizeName(name);
        Map<String, Object> map = this.variables;
        synchronized (map) {
            if (required && !this.variables.containsKey(normalizedName)) {
                throw new IllegalArgumentException("Variable '" + normalizedName + "' not found");
            }
            return this.variables.get(normalizedName);
        }
    }

    public void remove(String name) {
        this.variables.remove(this.normalizeName(name));
    }

    public boolean exists(String name) {
        return this.variables.containsKey(this.normalizeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setIfNone(String name, Supplier<T> supplier) {
        Map<String, Object> map = this.variables;
        synchronized (map) {
            if (!this.exists(name)) {
                this.set(name, supplier.get());
            }
        }
    }
}

