/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.kb;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.openksavi.sponge.config.ConfigException;
import org.openksavi.sponge.core.kb.BaseKnowledgeBaseScriptProvider;
import org.openksavi.sponge.core.kb.FileKnowledgeBaseScript;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBaseReaderHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileKnowledgeBaseScriptProvider
extends BaseKnowledgeBaseScriptProvider<FileKnowledgeBaseScript> {
    private static final Logger logger = LoggerFactory.getLogger(FileKnowledgeBaseScriptProvider.class);

    public FileKnowledgeBaseScriptProvider(SpongeEngine engine, FileKnowledgeBaseScript script) {
        super(engine, script);
    }

    public List<KnowledgeBaseReaderHolder> getReaders() throws IOException {
        Charset charset = ((FileKnowledgeBaseScript)this.script).getCharset() != null ? ((FileKnowledgeBaseScript)this.script).getCharset() : Charset.defaultCharset();
        List readers = this.engine.getKnowledgeBaseFileProvider().getReaders(this.engine, ((FileKnowledgeBaseScript)this.script).getFileName(), charset);
        if (readers.isEmpty()) {
            if (((FileKnowledgeBaseScript)this.script).isRequired()) {
                throw new ConfigException("Knowledge base file(s) " + ((FileKnowledgeBaseScript)this.script).getFileName() + " not found");
            }
            logger.info("The optional knowledge base file(s) " + ((FileKnowledgeBaseScript)this.script).getFileName() + " not found.");
        }
        return readers;
    }
}

