/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProcessConfiguration {
    private String name = "Process";
    private String executable;
    private List<String> arguments;
    private String workingDir;
    private Long waitSeconds;
    private RedirectType redirectType = RedirectType.INHERIT;
    private Charset charset;
    private String waitForOutputLineRegexp;
    private Long waitForOutputLineTimeout;

    public ProcessConfiguration(String executable) {
        this.executable = executable;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public Long getWaitSeconds() {
        return this.waitSeconds;
    }

    public void setWaitSeconds(Long waitSeconds) {
        this.waitSeconds = waitSeconds;
    }

    public RedirectType getRedirectType() {
        return this.redirectType;
    }

    public void setRedirectType(RedirectType redirectType) {
        this.redirectType = redirectType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getWaitForOutputLineRegexp() {
        return this.waitForOutputLineRegexp;
    }

    public void setWaitForOutputLineRegexp(String waitForOutputLineRegexp) {
        this.waitForOutputLineRegexp = waitForOutputLineRegexp;
    }

    public Long getWaitForOutputLineTimeout() {
        return this.waitForOutputLineTimeout;
    }

    public void setWaitForOutputLineTimeout(Long waitForOutputLineTimeout) {
        this.waitForOutputLineTimeout = waitForOutputLineTimeout;
    }

    public static Builder builder(String executable) {
        return new Builder(executable);
    }

    public static class Builder {
        private ProcessConfiguration configuration;

        public Builder(String executable) {
            this.configuration = new ProcessConfiguration(executable);
        }

        public ProcessConfiguration build() {
            return this.configuration;
        }

        public Builder name(String name) {
            this.configuration.setName(name);
            return this;
        }

        public Builder arguments(String ... arguments) {
            this.configuration.setArguments(Arrays.asList(arguments));
            return this;
        }

        public Builder arguments(List<String> arguments) {
            this.configuration.setArguments(new ArrayList<String>(arguments));
            return this;
        }

        public Builder workingDir(String workingDir) {
            this.configuration.setWorkingDir(workingDir);
            return this;
        }

        public Builder waitSeconds(Long waitSeconds) {
            this.configuration.setWaitSeconds(waitSeconds);
            return this;
        }

        public Builder redirectType(RedirectType redirectType) {
            this.configuration.setRedirectType(redirectType);
            return this;
        }

        public Builder charset(Charset charset) {
            this.configuration.setCharset(charset);
            return this;
        }

        public Builder waitForOutputLineRegexp(String waitForOutputLineRegexp) {
            this.configuration.setWaitForOutputLineRegexp(waitForOutputLineRegexp);
            return this;
        }

        public Builder waitForOutputLineTimeout(Long waitForOutputLineTimeout) {
            this.configuration.setWaitForOutputLineTimeout(waitForOutputLineTimeout);
            return this;
        }
    }

    public static enum RedirectType {
        LOGGER,
        INHERIT,
        STRING,
        NONE;

    }
}

