/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.kb;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.kb.KnowledgeBaseFileProvider;
import org.openksavi.sponge.kb.KnowledgeBaseReaderHolder;

public class DefaultKnowledgeBaseFileProvider
implements KnowledgeBaseFileProvider {
    public List<KnowledgeBaseReaderHolder> getReaders(SpongeEngine engine, String fileName, Charset charset) {
        String home;
        Validate.notBlank((CharSequence)fileName, (String)"A file name or pattern cannot be empty", (Object[])new Object[0]);
        Path filePath = (Path)Validate.notNull((Object)Paths.get(fileName, new String[0]), (String)"A file path is null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)(filePath.getFileName() != null ? filePath.getFileName().toString() : null), (String)"A file name or pattern cannot be empty", (Object[])new Object[0]);
        boolean isAbsolutePath = filePath.getParent() != null && filePath.getParent().isAbsolute();
        List<KnowledgeBaseReaderHolder> readers = null;
        readers = this.getNonWildcardReaders(null, fileName, charset);
        if (!readers.isEmpty()) {
            return readers;
        }
        readers = this.getWildcardReaders(filePath.getParent(), fileName, charset);
        if (!readers.isEmpty()) {
            return readers;
        }
        String configDir = SpongeUtils.getConfigurationFileDir(engine);
        if (configDir != null) {
            readers = this.getNonWildcardReaders(configDir, fileName, charset);
            if (!readers.isEmpty()) {
                return readers;
            }
            if (!isAbsolutePath && !(readers = this.getWildcardReaders(filePath.getParent() != null ? Paths.get(configDir, filePath.getParent().toString()) : Paths.get(configDir, new String[0]), fileName, charset)).isEmpty()) {
                return readers;
            }
        }
        if ((home = engine.getConfigurationManager().getHome()) != null) {
            readers = this.getNonWildcardReaders(home, fileName, charset);
            if (!readers.isEmpty()) {
                return readers;
            }
            if (!isAbsolutePath && !(readers = this.getWildcardReaders(filePath.getParent() != null ? Paths.get(home, filePath.getParent().toString()) : Paths.get(home, new String[0]), fileName, charset)).isEmpty()) {
                return readers;
            }
        }
        return Collections.emptyList();
    }

    protected List<KnowledgeBaseReaderHolder> getNonWildcardReaders(String dir, String fileName, Charset charset) {
        String fullFileName = dir != null ? Paths.get(dir, fileName).toString() : fileName;
        Reader reader = SpongeUtils.getReader(fullFileName, charset);
        return reader != null ? Arrays.asList(new KnowledgeBaseReaderHolder(reader, fullFileName)) : Collections.emptyList();
    }

    protected List<KnowledgeBaseReaderHolder> getWildcardReaders(Path dir, String fileName, Charset charset) {
        Path finalDir = dir != null ? dir : Paths.get(".", new String[0]);
        String fileNamePattern = Paths.get(fileName, new String[0]).getFileName().toString();
        ArrayList files = new ArrayList();
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(finalDir, fileNamePattern);){
            dirStream.forEach(files::add);
        }
        catch (NoSuchFileException | NotDirectoryException e) {
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new SpongeException("Error searching files in " + finalDir, (Throwable)e);
        }
        return files.stream().map(path -> new KnowledgeBaseReaderHolder(SpongeUtils.getReader(path.toString(), charset), path.toString())).collect(Collectors.toList());
    }
}

