/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.core.util.InputStreamLineConsumerRunnable;
import org.openksavi.sponge.core.util.ProcessConfiguration;
import org.openksavi.sponge.core.util.ProcessInstance;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.SpongeEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProcessUtils.class);
    public static final String TAG_PROCESS_EXECUTABLE = "executable";
    public static final String TAG_PROCESS_ARGUMENT = "argument";
    public static final String TAG_PROCESS_WORKING_DIR = "workingDir";
    public static final String TAG_PROCESS_ENV = "env";
    public static final String TAG_PROCESS_WAIT_SECONDS = "waitSeconds";
    public static final String TAG_PROCESS_REDIRECT_TYPE = "redirectType";
    public static final String TAG_PROCESS_CHARSET = "charset";
    public static final String TAG_PROCESS_WAIT_FOR_OUTPUT_LINE_REGEXP = "waitForOutputLineRegexp";
    public static final String TAG_PROCESS_WAIT_FOR_OUTPUT_LINE_TIMEOUT = "waitForOutputLineTimeout";
    public static final String ATTR_PROCESS_ENV_NAME = "name";

    public static ProcessConfiguration.Builder createProcessConfigurationBuilder(Configuration configuration) {
        String charsetString;
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
        Arrays.stream(configuration.getConfigurationsAt(TAG_PROCESS_ENV)).forEach(c -> env.put((String)Validate.notNull((Object)c.getAttribute(ATTR_PROCESS_ENV_NAME, null), (String)"The environment variable must have a name", (Object[])new Object[0]), c.getValue()));
        ProcessConfiguration.Builder builder = ProcessConfiguration.builder(configuration.getString(TAG_PROCESS_EXECUTABLE, null)).arguments(Arrays.stream(configuration.getConfigurationsAt(TAG_PROCESS_ARGUMENT)).map(Configuration::getValue).collect(Collectors.toList())).workingDir(configuration.getString(TAG_PROCESS_WORKING_DIR, null)).env(env).waitSeconds(configuration.getLong(TAG_PROCESS_WAIT_SECONDS, null));
        String redirectTypeString = configuration.getString(TAG_PROCESS_REDIRECT_TYPE, null);
        if (redirectTypeString != null) {
            builder.redirectType(ProcessConfiguration.RedirectType.valueOf(redirectTypeString));
        }
        if ((charsetString = configuration.getString(TAG_PROCESS_CHARSET, null)) != null) {
            builder.charset(Charset.forName(charsetString));
        }
        builder.waitForOutputLineRegexp(configuration.getString(TAG_PROCESS_WAIT_FOR_OUTPUT_LINE_REGEXP, null)).waitForOutputLineTimeout(configuration.getLong(TAG_PROCESS_WAIT_FOR_OUTPUT_LINE_TIMEOUT, null));
        return builder;
    }

    public static ProcessInstance startProcess(SpongeEngine engine, ProcessConfiguration processConfiguration) {
        if (processConfiguration.getWaitForOutputLineRegexp() != null) {
            return ProcessUtils.startProcessAndWaitForOutputLine(engine, processConfiguration);
        }
        return ProcessUtils.startProcessWithOutputLineConsumer(engine, processConfiguration, null);
    }

    public static ProcessInstance startProcessAndWaitForOutputLine(SpongeEngine engine, ProcessConfiguration processConfiguration) {
        Semaphore semaphore = new Semaphore(0);
        ProcessInstance processInstance = ProcessUtils.startProcessWithOutputLineConsumer(engine, processConfiguration, line -> {
            if (line.matches(processConfiguration.getWaitForOutputLineRegexp())) {
                semaphore.release();
            }
        });
        try {
            if (processConfiguration.getWaitForOutputLineTimeout() != null) {
                Validate.isTrue((boolean)semaphore.tryAcquire(processConfiguration.getWaitForOutputLineTimeout(), TimeUnit.SECONDS), (String)"Process wait timeout exceeded", (Object[])new Object[0]);
            } else {
                semaphore.acquire();
            }
        }
        catch (InterruptedException e) {
            throw SpongeUtils.wrapException(e);
        }
        return processInstance;
    }

    public static ProcessInstance startProcessWithOutputLineConsumer(SpongeEngine engine, ProcessConfiguration processConfiguration, Consumer<String> outputConsumer) {
        if (outputConsumer != null) {
            Validate.isTrue((processConfiguration.getRedirectType() == ProcessConfiguration.RedirectType.LOGGER ? 1 : 0) != 0, (String)"If the output consumer is provided, the redirect type must be LOGGER", (Object[])new Object[0]);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(processConfiguration.getExecutable());
        commands.addAll(processConfiguration.getArguments());
        ProcessBuilder builder = new ProcessBuilder(commands);
        if (processConfiguration.getRedirectType() == ProcessConfiguration.RedirectType.INHERIT) {
            builder.inheritIO();
        }
        if (processConfiguration.getWorkingDir() != null) {
            builder.directory(new File(processConfiguration.getWorkingDir()));
        }
        builder.environment().putAll(processConfiguration.getEnv());
        logger.debug("Starting a new subprocess: {} {}", (Object)processConfiguration.getExecutable(), processConfiguration.getArguments());
        if (!processConfiguration.getEnv().isEmpty()) {
            logger.debug("The subprocess additional environment: {}", processConfiguration.getEnv());
        }
        Charset finalCharset = processConfiguration.getCharset() != null ? processConfiguration.getCharset() : Charset.defaultCharset();
        ProcessInstance processInstance = null;
        try {
            processInstance = new ProcessInstance(builder.start(), processConfiguration);
            if (processConfiguration.getRedirectType() == ProcessConfiguration.RedirectType.LOGGER) {
                SpongeUtils.executeConcurrentlyOnce(engine, new InputStreamLineConsumerRunnable(processInstance.getProcess().getInputStream(), line -> {
                    logger.info(line);
                    if (outputConsumer != null) {
                        outputConsumer.accept((String)line);
                    }
                }, finalCharset));
                SpongeUtils.executeConcurrentlyOnce(engine, new InputStreamLineConsumerRunnable(processInstance.getProcess().getErrorStream(), arg_0 -> ((Logger)logger).warn(arg_0), finalCharset));
            }
        }
        catch (IOException e) {
            throw SpongeUtils.wrapException(processConfiguration.getName(), (Throwable)e);
        }
        if (processConfiguration.getRedirectType() == ProcessConfiguration.RedirectType.STRING) {
            try (BufferedReader output = new BufferedReader(new InputStreamReader(processInstance.getProcess().getInputStream(), finalCharset));
                 BufferedReader errors = new BufferedReader(new InputStreamReader(processInstance.getProcess().getErrorStream(), finalCharset));){
                processInstance.setOutput(output.lines().collect(Collectors.joining("\n")));
                logger.debug("{} output: {}", (Object)processConfiguration.getName(), (Object)processInstance.getOutput());
                String errorsString = errors.lines().collect(Collectors.joining("\n"));
                if (!errorsString.isEmpty()) {
                    throw new SpongeException(processConfiguration.getName() + " error: " + errorsString);
                }
            }
            catch (IOException e) {
                throw SpongeUtils.wrapException(processConfiguration.getName(), (Throwable)e);
            }
        }
        long elapsedSeconds = Duration.between(processInstance.getStartTime(), Instant.now()).getSeconds();
        if (processConfiguration.getWaitSeconds() != null && processConfiguration.getWaitSeconds() > elapsedSeconds) {
            try {
                processInstance.setFinished(processInstance.getProcess().waitFor(processConfiguration.getWaitSeconds() - elapsedSeconds, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                throw SpongeUtils.wrapException(e);
            }
        }
        return processInstance;
    }

    protected ProcessUtils() {
    }
}

