/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.ProcessorMeta;

public abstract class BaseProcessorMeta
implements ProcessorMeta {
    private String name;
    private String label;
    private String description;
    private Integer version;
    private Map<String, Object> features = new LinkedHashMap<String, Object>();
    private String category;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Map<String, Object> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, Object> features) {
        Validate.notNull(features, (String)"The processor features cannot be null", (Object[])new Object[0]);
        this.features = new LinkedHashMap<String, Object>(features);
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public BaseProcessorMeta withName(String name) {
        this.setName(name);
        return this;
    }

    public BaseProcessorMeta withLabel(String label) {
        this.setLabel(label);
        return this;
    }

    public BaseProcessorMeta withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public BaseProcessorMeta withVersion(Integer version) {
        this.setVersion(version);
        return this;
    }

    public BaseProcessorMeta withFeatures(Map<String, Object> features) {
        this.getFeatures().putAll(features);
        return this;
    }

    public BaseProcessorMeta withFeature(String name, Object value) {
        this.getFeatures().put(name, value);
        return this;
    }

    public BaseProcessorMeta withCategory(String category) {
        this.setCategory(category);
        return this;
    }
}

