/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core;

import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.ProcessorAdapter;
import org.openksavi.sponge.ProcessorQualifiedVersion;
import org.openksavi.sponge.core.BaseProcessor;
import org.openksavi.sponge.core.BaseProcessorDefinition;
import org.openksavi.sponge.core.BaseProcessorMeta;
import org.openksavi.sponge.core.ProcessorAdapterImplementor;
import org.openksavi.sponge.core.kb.BaseKnowledgeBase;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseProcessorAdapter<T extends Processor<?>>
implements ProcessorAdapter<T>,
ProcessorAdapterImplementor,
Cloneable {
    private BaseProcessorDefinition definition;
    private T processor;

    protected BaseProcessorAdapter(BaseProcessorDefinition definition) {
        this.definition = definition;
    }

    public BaseProcessorMeta getMeta() {
        return (BaseProcessorMeta)this.definition.getMeta();
    }

    public T getProcessor() {
        return this.processor;
    }

    public void setProcessor(T processor) {
        this.processor = processor;
        BaseProcessor processorImpl = (BaseProcessor)processor;
        if (processorImpl.getAdapter() == null) {
            processorImpl.setAdapter(this);
        }
    }

    @Override
    public void setDefinition(BaseProcessorDefinition definition) {
        if (this.definition != null) {
            return;
        }
        this.definition = definition;
    }

    @Override
    public BaseProcessorDefinition getDefinition() {
        return this.definition;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.definition.getKnowledgeBase();
    }

    @Override
    public void setKnowledgeBase(BaseKnowledgeBase knowledgeBase) {
        this.definition.setKnowledgeBase(knowledgeBase);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw SpongeUtils.wrapException(this.getMeta().getName(), (Throwable)e);
        }
    }

    public void clear() {
    }

    @Override
    public boolean isJavaDefined() {
        return this.definition.isJavaDefined();
    }

    public Logger getLogger() {
        return LoggerFactory.getLogger((String)SpongeUtils.createLoggerName(this.getKnowledgeBase(), this.getMeta().getName()));
    }

    public String toString() {
        return this.getMeta().getName() != null ? this.getMeta().getName() : super.toString();
    }

    public void validate() {
        Validate.isTrue((this.getMeta().getName() != null ? 1 : 0) != 0, (String)"Invalid %s. Name must not be empty.", (Object[])new Object[]{this.getType().getName()});
        Validate.isTrue((this.getMeta().getCategory() == null || this.getKnowledgeBase().getEngineOperations().getCategory(this.getMeta().getCategory()) != null ? 1 : 0) != 0, (String)"Category %s is not registered", (Object[])new Object[]{this.getMeta().getCategory()});
    }

    public ProcessorQualifiedVersion getQualifiedVersion() {
        return new ProcessorQualifiedVersion(this.getKnowledgeBase().getVersion(), this.getMeta().getVersion());
    }
}

