/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.action;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.action.Action;
import org.openksavi.sponge.action.ActionAdapter;
import org.openksavi.sponge.action.ActionMeta;
import org.openksavi.sponge.action.ProvideArgsContext;
import org.openksavi.sponge.core.BaseProcessorAdapter;
import org.openksavi.sponge.core.action.BaseActionDefinition;
import org.openksavi.sponge.core.action.BaseActionMeta;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.ProcessorType;
import org.openksavi.sponge.type.DataType;
import org.openksavi.sponge.type.provided.ProvidedValue;
import org.openksavi.sponge.util.SpongeApiUtils;

public class BaseActionAdapter
extends BaseProcessorAdapter<Action>
implements ActionAdapter {
    public BaseActionAdapter(BaseActionDefinition definition) {
        super(definition);
    }

    public ProcessorType getType() {
        return ProcessorType.ACTION;
    }

    @Override
    public BaseActionDefinition getDefinition() {
        return (BaseActionDefinition)super.getDefinition();
    }

    @Override
    public BaseActionMeta getMeta() {
        return (BaseActionMeta)super.getMeta();
    }

    public Map<String, ProvidedValue<?>> provideArgs(List<String> names, Map<String, Object> current) {
        Validate.notNull(this.getMeta().getArgs(), (String)"Arguments not defined", (Object[])new Object[0]);
        LinkedHashSet<String> finalNames = new LinkedHashSet<String>();
        if (names != null) {
            for (String name : names) {
                Validate.isTrue((boolean)BaseActionAdapter.isArgProvided(this.getMeta().getArg(name)), (String)"Argument '%s' is not defined as provided", (Object[])new Object[]{name});
                finalNames.add(name);
            }
        } else {
            SpongeApiUtils.traverseActionArguments((ActionMeta)this.getMeta(), qualifiedType -> {
                if (qualifiedType.getType().getProvided() != null) {
                    finalNames.add(qualifiedType.getPath());
                }
            }, (boolean)true);
        }
        if (current == null) {
            current = Collections.emptyMap();
        }
        LinkedHashMap provided = new LinkedHashMap();
        ((Action)this.getProcessor()).onProvideArgs(new ProvideArgsContext(finalNames, current, provided));
        provided.keySet().forEach(providedArg -> Validate.isTrue((this.getMeta().getArg((String)providedArg).getProvided() != null ? 1 : 0) != 0, (String)"The argument '%s' that has been provided is not configured as provided", (Object[])new Object[]{providedArg}));
        return provided;
    }

    @Override
    public void validate() {
        super.validate();
        Validate.isTrue((this.getMeta().getArgs() != null && this.getMeta().getResult() != null || this.getMeta().getArgs() == null && this.getMeta().getResult() == null ? 1 : 0) != 0, (String)"Both argument types and result type must be set or not", (Object[])new Object[0]);
        if (this.getMeta().getArgs() != null) {
            boolean foundFirstOptionalArg = false;
            for (DataType argType : this.getMeta().getArgs()) {
                this.validateArg(argType);
                Validate.isTrue((!foundFirstOptionalArg || argType.isOptional() ? 1 : 0) != 0, (String)"Only last arguments may be optional", (Object[])new Object[0]);
                if (!argType.isOptional()) continue;
                foundFirstOptionalArg = true;
            }
            this.validateArgProvided();
        }
        this.validateResult(this.getMeta().getResult());
    }

    private void validateArg(DataType argType) {
        Validate.notNull((Object)argType, (String)"Null argument type in the '%s' action", (Object[])new Object[]{this.getMeta().getName()});
        Validate.notNull((Object)argType.getName(), (String)"Argument has no name", (Object[])new Object[0]);
        SpongeUtils.validateType(argType, String.format("argument '%s'", argType.getName()));
    }

    private void validateArgProvided() {
        Map fullArgTypesMap = SpongeApiUtils.createNamedActionArgTypesMap((ActionMeta)this.getMeta());
        SpongeApiUtils.traverseActionArguments((ActionMeta)this.getMeta(), qualifiedType -> {
            DataType type = qualifiedType.getType();
            if (qualifiedType.getPath() != null) {
                if (type.getProvided() != null) {
                    type.getProvided().getDependencies().forEach(dependency -> Validate.isTrue((boolean)fullArgTypesMap.containsKey(dependency), (String)"The argument '%s' depends on an argument '%s' that is not defined or is not allowed", (Object[])new Object[]{qualifiedType.getPath(), dependency}));
                    Validate.isTrue((!type.getProvided().isReadOnly() || type.isNullable() ? 1 : 0) != 0, (String)"The provided, read only argument '%s' must be nullable", (Object[])new Object[]{qualifiedType.getPath()});
                }
            } else {
                Validate.isTrue((type.getProvided() == null ? 1 : 0) != 0, (String)"The %s argument is set as provided but doesn't have a complete name path", (Object[])new Object[]{type.getKind().name()});
            }
        }, (boolean)false);
    }

    private static boolean isArgProvided(DataType argType) {
        return argType.getProvided() != null;
    }

    private void validateResult(DataType resultType) {
        if (resultType != null) {
            String errorSource = String.format("result of the action '%s'", this.getMeta().getName());
            SpongeUtils.validateType(resultType, errorSource);
        }
    }
}

