/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine.processing.decomposed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.tuple.Pair;
import org.openksavi.sponge.EventProcessorAdapter;
import org.openksavi.sponge.core.engine.processing.EventProcessorRegistrationListener;
import org.openksavi.sponge.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecomposedQueue<T extends EventProcessorAdapter<?>>
implements EventProcessorRegistrationListener<T> {
    private static final Logger logger = LoggerFactory.getLogger(DecomposedQueue.class);
    private List<Pair<T, Event>> entries;
    private boolean allowConcurrentEventTypeProcessing;
    private Set<String> currentlyProcessedNonSingletons = Collections.synchronizedSet(new HashSet());
    private Set<String> currentlyProcessedEventNames = Collections.synchronizedSet(new HashSet());
    private int capacity;
    private Lock lock = new ReentrantLock(true);
    private Condition lockCondition = this.lock.newCondition();
    private Lock internalLock = new ReentrantLock(true);

    public DecomposedQueue(int capacity, boolean allowConcurrentEventTypeProcessing) {
        this.capacity = capacity;
        this.allowConcurrentEventTypeProcessing = allowConcurrentEventTypeProcessing;
        this.entries = Collections.synchronizedList(new ArrayList(capacity));
    }

    public boolean put(Pair<T, Event> entry) {
        this.lock.lock();
        try {
            this.internalLock.lock();
            if (this.entries.size() >= this.capacity) {
                boolean bl = false;
                return bl;
            }
            logger.debug("Put: {}", entry);
            this.entries.add(entry);
            this.lockCondition.signal();
            boolean bl = true;
            return bl;
        }
        finally {
            this.internalLock.unlock();
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<T, Event> get(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            Pair<T, Event> entry;
            while ((entry = this.doGetNonBlocking()) == null && this.lockCondition.await(timeout, unit)) {
            }
            if (entry != null) {
                logger.debug("Get: {}", entry);
            }
            Pair<T, Event> pair = entry;
            return pair;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pair<T, Event> doGetNonBlocking() {
        this.internalLock.lock();
        try {
            HashSet<String> nonSingletonsWaitningForEarlierEvent = new HashSet<String>();
            ListIterator<Pair<T, Event>> iterator = this.entries.listIterator();
            while (iterator.hasNext()) {
                Pair<T, Event> entry = iterator.next();
                EventProcessorAdapter adapter = (EventProcessorAdapter)entry.getLeft();
                Event event = (Event)entry.getRight();
                if (adapter.getDefinition().isSingleton()) {
                    iterator.remove();
                    Pair<T, Event> pair = entry;
                    return pair;
                }
                if (!(this.currentlyProcessedNonSingletons.contains(adapter.getMeta().getName()) || nonSingletonsWaitningForEarlierEvent.contains(adapter.getMeta().getName()) || !this.allowConcurrentEventTypeProcessing && this.currentlyProcessedEventNames.contains(event.getName()))) {
                    this.currentlyProcessedNonSingletons.add(adapter.getMeta().getName());
                    this.currentlyProcessedEventNames.add(event.getName());
                    iterator.remove();
                    Pair<T, Event> pair = entry;
                    return pair;
                }
                nonSingletonsWaitningForEarlierEvent.add(adapter.getMeta().getName());
            }
            Pair<T, Event> pair = null;
            return pair;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    public void release(Pair<T, Event> entry) {
        this.lock.lock();
        try {
            this.internalLock.lock();
            logger.debug("Release: {}", entry);
            this.currentlyProcessedNonSingletons.remove(((EventProcessorAdapter)entry.getLeft()).getMeta().getName());
            this.currentlyProcessedEventNames.remove(((Event)entry.getRight()).getName());
            this.lockCondition.signal();
        }
        finally {
            this.internalLock.unlock();
            this.lock.unlock();
        }
    }

    @Override
    public void onProcessorAdded(T eventProcessorAdapter) {
    }

    @Override
    public void onProcessorRemoved(T eventProcessorAdapter) {
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getSize() {
        return this.entries.size();
    }
}

