/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.rule;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openksavi.sponge.core.BaseEventSetProcessor;
import org.openksavi.sponge.core.rule.BaseRuleAdapter;
import org.openksavi.sponge.core.rule.BaseRuleDefinition;
import org.openksavi.sponge.core.rule.BaseRuleMeta;
import org.openksavi.sponge.core.rule.CompositeEventCondition;
import org.openksavi.sponge.core.rule.ReflectionEventCondition;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.rule.EventCondition;
import org.openksavi.sponge.rule.EventMode;
import org.openksavi.sponge.rule.Rule;
import org.openksavi.sponge.rule.RuleAdapter;
import org.openksavi.sponge.rule.RuleEventSpec;

public abstract class BaseRule
extends BaseEventSetProcessor<RuleAdapter>
implements Rule {
    protected final BaseRuleAdapter getRuleAdapterImpl() {
        return (BaseRuleAdapter)super.getAdapter();
    }

    @Override
    public BaseRuleMeta getMeta() {
        return (BaseRuleMeta)super.getMeta();
    }

    public final Event getEvent(String eventAlias) {
        return this.getRuleAdapterImpl().getEvent(eventAlias);
    }

    public final RuleEventSpec makeEventSpec(String eventName, String eventAlias, EventMode eventMode) {
        return this.getRuleAdapterImpl().makeEventSpec(eventName, eventAlias, eventMode);
    }

    public final RuleEventSpec makeEventSpec(String eventName, EventMode eventMode) {
        return this.getRuleAdapterImpl().makeEventSpec(eventName, eventMode);
    }

    public final RuleEventSpec makeEventSpec(String eventName, String eventAlias) {
        return this.getRuleAdapterImpl().makeEventSpec(eventName, eventAlias);
    }

    public final RuleEventSpec makeEventSpec(String eventName) {
        return this.getRuleAdapterImpl().makeEventSpec(eventName);
    }

    public final Map<String, Event> getEventAliasMap() {
        return this.getRuleAdapterImpl().getEventAliasMap();
    }

    public final List<Event> getEventSequence() {
        return this.getRuleAdapterImpl().getEventSequence();
    }

    public final RuleAdapter createAdapter() {
        return new BaseRuleAdapter(new BaseRuleDefinition());
    }

    protected final EventCondition createEventConditionForMethods(List<String> names) {
        return names.size() == 1 ? this.createEventConditionForMethod(names.get(0)) : new CompositeEventCondition(names.stream().map(name -> this.createEventConditionForMethod((String)name)).collect(Collectors.toList()));
    }

    protected final EventCondition createEventConditionForMethod(String name) {
        return ReflectionEventCondition.create(this, name);
    }

    public BaseRule withName(String name) {
        return (BaseRule)super.withName(name);
    }

    public BaseRule withLabel(String label) {
        return (BaseRule)super.withLabel(label);
    }

    public BaseRule withDescription(String description) {
        return (BaseRule)super.withDescription(description);
    }

    public BaseRule withVersion(Integer version) {
        return (BaseRule)super.withVersion(version);
    }

    public BaseRule withFeatures(Map<String, Object> features) {
        return (BaseRule)super.withFeatures(features);
    }

    public BaseRule withFeature(String name, Object value) {
        return (BaseRule)super.withFeature(name, value);
    }

    public BaseRule withCategory(String category) {
        return (BaseRule)super.withCategory(category);
    }

    public BaseRule withEvents(List<String> eventStringSpecs) {
        this.getMeta().addEventSpecs(eventStringSpecs.stream().map(spec -> this.getKnowledgeBase().getInterpreter().getRuleEventSpec(spec)).collect(Collectors.toList()));
        return this;
    }

    public BaseRule withEvent(String eventStringSpec) {
        return this.withEvents((List)Arrays.asList(eventStringSpec));
    }

    public BaseRule withDuration(Duration duration) {
        return (BaseRule)super.withDuration(duration);
    }

    public BaseRule withSynchronous(Boolean synchronous) {
        return (BaseRule)super.withSynchronous(synchronous);
    }

    public BaseRule withEventConditions(String eventAlias, List<EventCondition> conditions) {
        this.getMeta().addEventConditions(eventAlias, conditions);
        return this;
    }

    public BaseRule withEventCondition(String eventAlias, EventCondition condition) {
        this.withEventConditions(eventAlias, Arrays.asList(condition));
        return this;
    }

    public BaseRule withAllEventConditions(List<EventCondition> conditions) {
        this.getMeta().addAllEventConditions(conditions);
        return this;
    }

    public BaseRule withAllEventCondition(EventCondition condition) {
        return this.withAllEventConditions(Arrays.asList(condition));
    }

    public BaseRule withEventSpecs(List<RuleEventSpec> eventSpecs) {
        this.getMeta().addEventSpecs(eventSpecs);
        return this;
    }

    public BaseRule withEventSpec(RuleEventSpec eventSpec) {
        return this.withEventSpecs(Arrays.asList(eventSpec));
    }

    public BaseRule withOrdered(boolean ordered) {
        this.getMeta().setOrdered(ordered);
        return this;
    }
}

