/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.util;

import java.time.Duration;
import java.util.function.Function;
import org.openksavi.sponge.core.util.GuavaLocalCache;
import org.openksavi.sponge.core.util.GuavaLocalLoadingCache;
import org.openksavi.sponge.core.util.LocalCache;
import org.openksavi.sponge.core.util.LocalLoadingCache;
import org.openksavi.sponge.shaded.com.google.common.cache.CacheBuilder;
import org.openksavi.sponge.shaded.com.google.common.cache.CacheLoader;

public class LocalCacheBuilder {
    private CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder();

    public LocalCacheBuilder expireAfterAccess(Duration duration) {
        this.builder.expireAfterAccess(duration);
        return this;
    }

    public LocalCacheBuilder expireAfterWrite(Duration duration) {
        this.builder.expireAfterWrite(duration);
        return this;
    }

    public LocalCacheBuilder initialCapacity(int initialCapacity) {
        this.builder.initialCapacity(initialCapacity);
        return this;
    }

    public LocalCacheBuilder maximumSize(long maximumSize) {
        this.builder.maximumSize(maximumSize);
        return this;
    }

    public LocalCacheBuilder refreshAfterWrite(Duration duration) {
        this.builder.refreshAfterWrite(duration);
        return this;
    }

    public LocalCacheBuilder softValues() {
        this.builder.softValues();
        return this;
    }

    public LocalCacheBuilder weakKeys() {
        this.builder.weakKeys();
        return this;
    }

    public LocalCacheBuilder weakValues() {
        this.builder.weakValues();
        return this;
    }

    public <K, V> LocalLoadingCache<K, V> build(final Function<K, V> loader) {
        return new GuavaLocalLoadingCache(this.builder.build(new CacheLoader<K, V>(){

            @Override
            public V load(K key) {
                return loader.apply(key);
            }
        }));
    }

    public <K, V> LocalCache<K, V> build() {
        return new GuavaLocalCache(this.builder.build());
    }
}

