/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.examples;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.java.JRule;
import org.openksavi.sponge.rule.EventCondition;
import org.openksavi.sponge.rule.EventMode;
import org.openksavi.sponge.rule.RuleEventSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameSourceJavaRule
extends JRule {
    private static final Logger logger = LoggerFactory.getLogger(SameSourceJavaRule.class);

    public void onConfigure() {
        this.withEventSpecs(new RuleEventSpec[]{new RuleEventSpec("filesystemFailure", "e1"), new RuleEventSpec("diskFailure", "e2", EventMode.ALL)});
        this.withAllConditions(new String[]{"severityCondition"});
        this.withConditions("e2", new EventCondition[]{(rule, event) -> {
            Event event1 = rule.getEvent("e1");
            return event.get("source").equals(event1.get("source")) && Duration.between(event1.getTime(), event.getTime()).getSeconds() <= 4L;
        }});
        this.withDuration(Duration.ofSeconds(8L));
    }

    public void onRun(Event event) {
        logger.info("Monitoring log [{}]: Critical failure in {}! Events: {}", new Object[]{event.getTime(), event.get("source"), this.getEventAliasMap()});
        ((AtomicInteger)this.getSponge().getVariable(AtomicInteger.class, "hardwareFailureJavaCount")).incrementAndGet();
    }

    public boolean severityCondition(Event event) {
        return ((Number)event.get(Number.class, "severity")).intValue() > 5;
    }
}

