/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.features.model.geo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openksavi.sponge.SpongeException;

public class GeoCrs
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4203026325077705441L;
    private String code;
    private String projection;
    private List<Double> resolutions = new ArrayList<Double>();

    public GeoCrs(String code, String projection) {
        this.code = code;
        this.projection = projection;
    }

    public GeoCrs(String code) {
        this(code, null);
    }

    public GeoCrs() {
    }

    public GeoCrs withCode(String code) {
        this.setCode(code);
        return this;
    }

    public GeoCrs withProjection(String projection) {
        this.setProjection(projection);
        return this;
    }

    public GeoCrs withResolutions(List<Number> resolutions) {
        this.resolutions.addAll(resolutions.stream().map(r -> r != null ? Double.valueOf(r.doubleValue()) : null).collect(Collectors.toList()));
        return this;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getProjection() {
        return this.projection;
    }

    public void setProjection(String projection) {
        this.projection = projection;
    }

    public List<Double> getResolutions() {
        return this.resolutions;
    }

    public void setResolutions(List<Double> resolutions) {
        this.resolutions = resolutions;
    }

    public GeoCrs clone() {
        try {
            GeoCrs cloned = (GeoCrs)super.clone();
            cloned.resolutions = this.resolutions != null ? new ArrayList<Double>(this.resolutions) : null;
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new SpongeException((Throwable)e);
        }
    }
}

