/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.features.model.geo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.features.model.geo.GeoCrs;
import org.openksavi.sponge.features.model.geo.GeoLayer;
import org.openksavi.sponge.features.model.geo.GeoPosition;
import org.openksavi.sponge.util.HasFeatures;

public class GeoMap
implements HasFeatures,
Serializable,
Cloneable {
    private static final long serialVersionUID = 659974545540192399L;
    private GeoPosition center;
    private Double zoom;
    private Double minZoom;
    private Double maxZoom;
    private GeoCrs crs;
    private List<GeoLayer> layers = new ArrayList<GeoLayer>();
    private Map<String, Object> features = new LinkedHashMap<String, Object>();

    public GeoMap withCenter(GeoPosition center) {
        this.setCenter(center);
        return this;
    }

    public GeoMap withZoom(Double zoom) {
        this.setZoom(zoom);
        return this;
    }

    public GeoMap withMinZoom(Double minZoom) {
        this.setMinZoom(minZoom);
        return this;
    }

    public GeoMap withMaxZoom(Double maxZoom) {
        this.setMaxZoom(maxZoom);
        return this;
    }

    public GeoMap withCrs(GeoCrs crs) {
        this.setCrs(crs);
        return this;
    }

    public GeoMap withLayers(List<GeoLayer> layers) {
        this.layers.addAll(layers);
        return this;
    }

    public GeoMap withLayer(GeoLayer layer) {
        this.layers.add(layer);
        return this;
    }

    public GeoMap withFeatures(Map<String, Object> features) {
        this.features.putAll(features);
        return this;
    }

    public GeoMap withFeature(String name, Object value) {
        this.features.put(name, value);
        return this;
    }

    public GeoPosition getCenter() {
        return this.center;
    }

    public void setCenter(GeoPosition center) {
        this.center = center;
    }

    public Double getZoom() {
        return this.zoom;
    }

    public void setZoom(Double zoom) {
        this.zoom = zoom;
    }

    public Double getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(Double minZoom) {
        this.minZoom = minZoom;
    }

    public Double getMaxZoom() {
        return this.maxZoom;
    }

    public void setMaxZoom(Double maxZoom) {
        this.maxZoom = maxZoom;
    }

    public GeoCrs getCrs() {
        return this.crs;
    }

    public void setCrs(GeoCrs crs) {
        this.crs = crs;
    }

    public List<GeoLayer> getLayers() {
        return this.layers;
    }

    public void setLayers(List<GeoLayer> layers) {
        this.layers = layers;
    }

    public Map<String, Object> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, Object> features) {
        this.features = features;
    }

    public GeoMap clone() {
        try {
            GeoMap cloned = (GeoMap)super.clone();
            cloned.center = this.center != null ? this.center.clone() : null;
            cloned.crs = this.crs != null ? this.crs.clone() : null;
            cloned.layers = this.layers != null ? this.layers.stream().map(layer -> layer.clone()).collect(Collectors.toList()) : null;
            cloned.features = this.features != null ? new LinkedHashMap<String, Object>(this.features) : null;
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new SpongeException((Throwable)e);
        }
    }
}

