/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.features.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.util.HasFeatures;

public class SubActionArg
implements HasFeatures,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7230022622488900038L;
    private String target;
    private String source;
    private Map<String, Object> features = new LinkedHashMap<String, Object>();

    public SubActionArg(String target, String source) {
        this.target = target;
        this.source = source;
    }

    public SubActionArg() {
    }

    public SubActionArg withTarget(String target) {
        this.setTarget(target);
        return this;
    }

    public SubActionArg withSource(String source) {
        this.setSource(source);
        return this;
    }

    public SubActionArg withFeatures(Map<String, Object> features) {
        this.features.putAll(features);
        return this;
    }

    public SubActionArg withFeature(String name, Object value) {
        this.features.put(name, value);
        return this;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Map<String, Object> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, Object> features) {
        this.features = features;
    }

    public SubActionArg clone() {
        try {
            SubActionArg cloned = (SubActionArg)super.clone();
            cloned.features = this.features != null ? new LinkedHashMap<String, Object>(this.features) : null;
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new SpongeException((Throwable)e);
        }
    }
}

