/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.features.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.features.model.SubActionArg;
import org.openksavi.sponge.features.model.SubActionResult;
import org.openksavi.sponge.util.Descriptive;
import org.openksavi.sponge.util.HasFeatures;

public class SubAction
implements HasFeatures,
Descriptive,
Serializable,
Cloneable {
    private static final long serialVersionUID = -9111976205752523512L;
    private String name;
    private String label;
    private String description;
    private List<SubActionArg> args = new ArrayList<SubActionArg>();
    private SubActionResult result;
    private Map<String, Object> features = new LinkedHashMap<String, Object>();

    public SubAction(String name) {
        this.name = name;
    }

    public SubAction() {
    }

    public SubAction withName(String name) {
        this.setName(name);
        return this;
    }

    public SubAction withLabel(String label) {
        this.setLabel(label);
        return this;
    }

    public SubAction withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public SubAction withArgs(List<SubActionArg> args) {
        args.addAll(args);
        return this;
    }

    public SubAction withArg(SubActionArg arg) {
        this.args.add(arg);
        return this;
    }

    public SubAction withArg(String target, String source) {
        return this.withArg(new SubActionArg(target, source));
    }

    public SubAction withResult(SubActionResult result) {
        this.setResult(result);
        return this;
    }

    public SubAction withResult(String target) {
        return this.withResult(new SubActionResult(target));
    }

    public SubAction withFeatures(Map<String, Object> features) {
        this.features.putAll(features);
        return this;
    }

    public SubAction withFeature(String name, Object value) {
        this.features.put(name, value);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<SubActionArg> getArgs() {
        return this.args;
    }

    public void setArgs(List<SubActionArg> args) {
        this.args = args;
    }

    public SubActionResult getResult() {
        return this.result;
    }

    public void setResult(SubActionResult result) {
        this.result = result;
    }

    public Map<String, Object> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, Object> features) {
        this.features = features;
    }

    public SubAction clone() {
        try {
            SubAction cloned = (SubAction)super.clone();
            cloned.args = this.args != null ? this.args.stream().map(arg -> arg.clone()).collect(Collectors.toList()) : null;
            cloned.result = this.result != null ? this.result.clone() : null;
            cloned.features = this.features != null ? new LinkedHashMap<String, Object>(this.features) : null;
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new SpongeException((Throwable)e);
        }
    }
}

