/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.features.model.geo;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.features.model.geo.GeoLayerType;
import org.openksavi.sponge.util.Descriptive;
import org.openksavi.sponge.util.HasFeatures;

public abstract class GeoLayer
implements Descriptive,
HasFeatures,
Serializable,
Cloneable {
    private static final long serialVersionUID = -4882052436310260925L;
    private GeoLayerType type;
    private String name;
    private String label;
    private String description;
    private Map<String, Object> features = new LinkedHashMap<String, Object>();

    protected GeoLayer(GeoLayerType type, String name) {
        this.type = type;
        this.name = name;
    }

    protected GeoLayer(GeoLayerType type) {
        this(type, null);
    }

    public GeoLayer withName(String name) {
        this.setName(name);
        return this;
    }

    public GeoLayer withLabel(String label) {
        this.setLabel(label);
        return this;
    }

    public GeoLayer withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public GeoLayer withFeatures(Map<String, Object> features) {
        this.features.putAll(features);
        return this;
    }

    public GeoLayer withFeature(String name, Object value) {
        this.features.put(name, value);
        return this;
    }

    public GeoLayerType getType() {
        return this.type;
    }

    public void setType(GeoLayerType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, Object> features) {
        this.features = features;
    }

    public GeoLayer clone() {
        try {
            GeoLayer cloned = (GeoLayer)super.clone();
            cloned.features = this.features != null ? new LinkedHashMap<String, Object>(this.features) : null;
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new SpongeException((Throwable)e);
        }
    }
}

