/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.features.model.geo;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openksavi.sponge.features.model.geo.GeoCrs;
import org.openksavi.sponge.features.model.geo.GeoLayer;
import org.openksavi.sponge.features.model.geo.GeoLayerType;

public class GeoWmsLayer
extends GeoLayer {
    private static final long serialVersionUID = 6335447555965836764L;
    private String baseUrl;
    private List<String> layers = new ArrayList<String>();
    private GeoCrs crs;
    private String format;
    private String version;
    private List<String> styles = new ArrayList<String>();
    private Boolean transparent;
    private Map<String, String> otherParameters = new LinkedHashMap<String, String>();

    public GeoWmsLayer(String name) {
        super(GeoLayerType.WMS, name);
    }

    public GeoWmsLayer() {
        this((String)null);
    }

    @Override
    public GeoWmsLayer withName(String name) {
        return (GeoWmsLayer)super.withName(name);
    }

    @Override
    public GeoWmsLayer withLabel(String label) {
        return (GeoWmsLayer)super.withLabel(label);
    }

    @Override
    public GeoWmsLayer withDescription(String description) {
        return (GeoWmsLayer)super.withDescription(description);
    }

    @Override
    public GeoWmsLayer withFeatures(Map<String, Object> features) {
        return (GeoWmsLayer)super.withFeatures(features);
    }

    @Override
    public GeoWmsLayer withFeature(String name, Object value) {
        return (GeoWmsLayer)super.withFeature(name, value);
    }

    public GeoWmsLayer withBaseUrl(String baseUrl) {
        this.setBaseUrl(baseUrl);
        return this;
    }

    public GeoWmsLayer withLayers(List<String> layers) {
        this.layers.addAll(layers);
        return this;
    }

    public GeoWmsLayer withLayer(String layer) {
        this.layers.add(layer);
        return this;
    }

    public GeoWmsLayer withCrs(GeoCrs crs) {
        this.setCrs(crs);
        return this;
    }

    public GeoWmsLayer withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public GeoWmsLayer withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public GeoWmsLayer withStyles(List<String> styles) {
        this.styles.addAll(styles);
        return this;
    }

    public GeoWmsLayer withTransparent(Boolean transparent) {
        this.setTransparent(transparent);
        return this;
    }

    public GeoWmsLayer withOtherParameters(Map<String, String> otherParameters) {
        this.otherParameters.putAll(otherParameters);
        return this;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public List<String> getLayers() {
        return this.layers;
    }

    public void setLayers(List<String> layers) {
        this.layers = layers;
    }

    public GeoCrs getCrs() {
        return this.crs;
    }

    public void setCrs(GeoCrs crs) {
        this.crs = crs;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<String> getStyles() {
        return this.styles;
    }

    public void setStyles(List<String> styles) {
        this.styles = styles;
    }

    public Boolean getTransparent() {
        return this.transparent;
    }

    public void setTransparent(Boolean transparent) {
        this.transparent = transparent;
    }

    public Map<String, String> getOtherParameters() {
        return this.otherParameters;
    }

    public void setOtherParameters(Map<String, String> otherParameters) {
        this.otherParameters = otherParameters;
    }

    @Override
    public GeoWmsLayer clone() {
        GeoWmsLayer cloned = (GeoWmsLayer)super.clone();
        cloned.layers = this.layers != null ? new ArrayList<String>(this.layers) : null;
        cloned.crs = this.crs != null ? this.crs.clone() : null;
        cloned.styles = this.styles != null ? new ArrayList<String>(this.styles) : null;
        cloned.otherParameters = this.otherParameters != null ? new LinkedHashMap<String, String>(this.otherParameters) : null;
        return cloned;
    }
}

