/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.gsmmodem;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.gsmmodem.GsmModemUtils;
import org.openksavi.sponge.java.JPlugin;
import org.openksavi.sponge.util.process.ProcessConfiguration;
import org.openksavi.sponge.util.process.ProcessInstance;

public class GammuGsmModemPlugin
extends JPlugin {
    public static final String DEFAULT_PLUGIN_NAME = "gsm";
    private Lock lock = new ReentrantLock(true);

    public GammuGsmModemPlugin() {
        this.setName(DEFAULT_PLUGIN_NAME);
    }

    public GammuGsmModemPlugin(String name) {
        super(name);
    }

    public void sendSms(String number, String message) {
        this.lock.lock();
        try {
            String unicode = this.canEncodeGsm(message) ? null : "-unicode";
            ProcessInstance process = this.getEngineOperations().process(ProcessConfiguration.builder((String)"gammu", (String[])new String[0]).arguments(new String[]{"sendsms", "TEXT", number, unicode}).inputAsString(message).outputAsString()).run();
            if (process.waitFor() != 0) {
                throw new SpongeException(String.format("Exit code %d: %s", process.getExitCode(), process.getOutputString()));
            }
        }
        catch (InterruptedException e) {
            throw SpongeUtils.wrapException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean canEncodeGsm(String text) {
        return GsmModemUtils.canEncodeGsm(text);
    }
}

