/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.gsmmodem;

import org.openksavi.sponge.Experimental;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.gsmmodem.serial.SerialPortGsmModem;
import org.openksavi.sponge.gsmmodem.serial.SerialPortGsmModemConfiguration;
import org.openksavi.sponge.java.JPlugin;

@Experimental
public class SerialPortGsmModemPlugin
extends JPlugin {
    public static final String DEFAULT_PLUGIN_NAME = "gsm";
    private SerialPortGsmModemConfiguration modemConfiguration;
    private SerialPortGsmModem modem;

    public SerialPortGsmModemPlugin() {
        this.setName(DEFAULT_PLUGIN_NAME);
    }

    public SerialPortGsmModemPlugin(String name) {
        super(name);
    }

    public void onConfigure(Configuration configuration) {
        SerialPortGsmModemConfiguration.Builder builder = SerialPortGsmModemConfiguration.builder();
        builder.portDescriptor(configuration.getString("portDescriptor", null));
        this.modemConfiguration = builder.build();
    }

    public void onStartup() {
        if (this.modem == null) {
            this.modem = new SerialPortGsmModem(this.modemConfiguration);
            this.modem.open();
        }
    }

    public void onShutdown() {
        if (this.modem != null) {
            this.modem.close();
        }
    }

    public SerialPortGsmModemConfiguration getModemConfiguration() {
        return this.modemConfiguration;
    }

    public void setModemConfiguration(SerialPortGsmModemConfiguration modemConfiguration) {
        this.modemConfiguration = modemConfiguration;
    }

    public SerialPortGsmModem getModem() {
        return this.modem;
    }

    public void setModem(SerialPortGsmModem modem) {
        this.modem = modem;
    }
}

