/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.gsmmodem.serial;

import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.gsmmodem.serial.SerialPortGsmModemConstants;

public class SerialPortGsmModemConfiguration {
    private String portDescriptor;
    private String charsetName = SerialPortGsmModemConstants.DEFAULT_CHARSET_NAME;

    protected SerialPortGsmModemConfiguration() {
    }

    public String getPortDescriptor() {
        return this.portDescriptor;
    }

    public void setPortDescriptor(String portDescriptor) {
        this.portDescriptor = portDescriptor;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SerialPortGsmModemConfiguration configuration = new SerialPortGsmModemConfiguration();

        public SerialPortGsmModemConfiguration build() {
            Validate.notNull((Object)this.configuration.getPortDescriptor(), (String)"Port descriptor not set", (Object[])new Object[0]);
            return this.configuration;
        }

        public Builder portDescriptor(String portDescriptor) {
            this.configuration.setPortDescriptor(portDescriptor);
            return this;
        }

        public Builder charsetName(String charsetName) {
            this.configuration.setCharsetName(charsetName);
            return this;
        }
    }
}

