/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.gsmmodem.serial;

import com.fazecast.jSerialComm.SerialPort;
import java.nio.charset.Charset;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.Experimental;
import org.openksavi.sponge.gsmmodem.serial.SerialPortGsmModemConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class SerialPortGsmModem {
    private static final Logger logger = LoggerFactory.getLogger(SerialPortGsmModem.class);
    private SerialPortGsmModemConfiguration configuration;
    private SerialPort serialPort;
    private Charset charset;
    private Lock lock = new ReentrantLock(true);

    public SerialPortGsmModem(SerialPortGsmModemConfiguration configuration) {
        this.configuration = configuration;
    }

    public SerialPortGsmModem(SerialPort serialPort) {
        this.serialPort = serialPort;
    }

    public void open() {
        if (this.serialPort == null) {
            Validate.notNull((Object)this.configuration, (String)"Either a configuration or a serial port must be set", (Object[])new Object[0]);
            this.serialPort = SerialPort.getCommPort((String)this.configuration.getPortDescriptor());
        }
        this.charset = Charset.forName(this.configuration != null && this.configuration.getCharsetName() != null ? this.configuration.getCharsetName() : "UTF-8");
        Validate.isTrue((boolean)this.serialPort.openPort(), (String)"The port %s couldn't be opened", (Object[])new Object[]{this.serialPort.getSystemPortName()});
    }

    public void close() {
        if (this.serialPort != null) {
            Validate.isTrue((boolean)this.serialPort.closePort(), (String)"The port couldn't be closed", (Object[])new Object[0]);
        }
    }

    protected void validateSerialPort() {
        Validate.notNull((Object)this.serialPort, (String)"Serial port is not opened", (Object[])new Object[0]);
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    public void setSerialPort(SerialPort serialPort) {
        this.serialPort = serialPort;
    }

    public void write(String message) {
        this.write(message.getBytes(this.charset));
    }

    public void write(byte data) {
        this.write(new byte[]{data});
    }

    public void write(byte[] bytes) {
        this.validateSerialPort();
        this.lock.lock();
        try {
            Validate.isTrue((this.serialPort.writeBytes(bytes, (long)bytes.length) == bytes.length ? 1 : 0) != 0, (String)"Writing bytes failure", (Object[])new Object[0]);
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] readBytes() {
        this.validateSerialPort();
        byte[] bytes = new byte[this.serialPort.bytesAvailable()];
        Validate.isTrue((this.serialPort.readBytes(bytes, (long)bytes.length) == bytes.length ? 1 : 0) != 0, (String)"Reading bytes failure", (Object[])new Object[0]);
        return bytes;
    }

    public String readString(Charset charset) {
        String response = new String(this.readBytes(), charset);
        logger.debug("Read: {}", (Object)response);
        return response;
    }

    public String readString(String charsetName) {
        return this.readString(Charset.forName(charsetName));
    }

    public String readString() {
        return this.readString(this.charset);
    }

    public void sendAtCmd(String cmd) {
        logger.debug("Writing: {}", (Object)cmd);
        this.write("AT" + cmd + "\r");
    }
}

