/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.jython.shaded.jnr.posix;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.openksavi.sponge.jython.shaded.jnr.constants.platform.Sysconf;
import org.openksavi.sponge.jython.shaded.jnr.ffi.Memory;
import org.openksavi.sponge.jython.shaded.jnr.ffi.Pointer;
import org.openksavi.sponge.jython.shaded.jnr.ffi.mapper.FromNativeContext;
import org.openksavi.sponge.jython.shaded.jnr.posix.BaseNativePOSIX;
import org.openksavi.sponge.jython.shaded.jnr.posix.FileStat;
import org.openksavi.sponge.jython.shaded.jnr.posix.FreeBSDFileStat;
import org.openksavi.sponge.jython.shaded.jnr.posix.FreeBSDFileStat12;
import org.openksavi.sponge.jython.shaded.jnr.posix.FreeBSDPasswd;
import org.openksavi.sponge.jython.shaded.jnr.posix.LibCProvider;
import org.openksavi.sponge.jython.shaded.jnr.posix.MsgHdr;
import org.openksavi.sponge.jython.shaded.jnr.posix.NativeTimes;
import org.openksavi.sponge.jython.shaded.jnr.posix.POSIXHandler;
import org.openksavi.sponge.jython.shaded.jnr.posix.SocketMacros;
import org.openksavi.sponge.jython.shaded.jnr.posix.Times;
import org.openksavi.sponge.jython.shaded.jnr.posix.util.MethodName;

final class FreeBSDPOSIX
extends BaseNativePOSIX {
    private final int freebsdVersion;
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new FreeBSDPasswd((Pointer)arg) : null;
        }
    };

    FreeBSDPOSIX(LibCProvider libc, POSIXHandler handler2) {
        super(libc, handler2);
        int parsed_version = 0;
        try {
            Process p = Runtime.getRuntime().exec("/bin/freebsd-version -u");
            String version2 = new BufferedReader(new InputStreamReader(p.getInputStream())).readLine();
            if (p.waitFor() == 0 && version2 != null) {
                NumberFormat fmt = NumberFormat.getIntegerInstance();
                fmt.setGroupingUsed(false);
                parsed_version = fmt.parse(version2, new ParsePosition(0)).intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.freebsdVersion = parsed_version;
    }

    @Override
    public FileStat allocateStat() {
        if (this.freebsdVersion >= 12) {
            return new FreeBSDFileStat12(this);
        }
        return new FreeBSDFileStat(this);
    }

    @Override
    public MsgHdr allocateMsgHdr() {
        this.handler.unimplementedError(MethodName.getCallerMethodName());
        return null;
    }

    @Override
    public SocketMacros socketMacros() {
        this.handler.unimplementedError(MethodName.getCallerMethodName());
        return null;
    }

    @Override
    public long sysconf(Sysconf name) {
        return this.libc().sysconf(name);
    }

    @Override
    public Times times() {
        return NativeTimes.times(this);
    }

    @Override
    public Pointer allocatePosixSpawnFileActions() {
        return Memory.allocateDirect(this.getRuntime(), 8);
    }

    @Override
    public Pointer allocatePosixSpawnattr() {
        return Memory.allocateDirect(this.getRuntime(), 8);
    }
}

