/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.Library;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.Untraversable;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedType;
import org.python.modules.jffi.BasePointer;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.DynamicLibrary$PyExposer;
import org.python.modules.jffi.DynamicLibrary$Symbol$PyExposer;
import org.python.modules.jffi.NativeMemory;

@Untraversable
@ExposedType(name="jffi.DynamicLibrary", base=PyObject.class)
public class DynamicLibrary
extends PyObject {
    public static final PyType TYPE;
    public final String name;
    private final Library lib;

    DynamicLibrary(String libname, int mode) {
        this.name = libname;
        this.lib = Library.getCachedInstance(libname, mode);
        if (this.lib == null) {
            throw Py.RuntimeError("Could not open " + libname != null ? libname : "[current process] " + Library.getLastError());
        }
    }

    private long findSymbol(PyObject name) {
        long address = this.lib.getSymbolAddress(name.asString());
        if (address == 0L) {
            throw Py.NameError("Could not locate symbol '" + name.asString() + "' in " + this.name);
        }
        return address;
    }

    public final PyObject find_symbol(PyObject name) {
        long address = this.findSymbol(name);
        return new Symbol(this, name.asString(), new NativeMemory(address));
    }

    public final PyObject find_function(PyObject name) {
        return new TextSymbol(this, name.asString(), this.findSymbol(name));
    }

    public final PyObject find_variable(PyObject name) {
        return new DataSymbol(this, name.asString(), this.findSymbol(name));
    }

    static {
        PyType.addBuilder(DynamicLibrary.class, new DynamicLibrary$PyExposer());
        TYPE = PyType.fromClass(DynamicLibrary.class);
    }

    private static final class SymbolMemory
    extends NativeMemory {
        private final DynamicLibrary library;

        public SymbolMemory(DynamicLibrary library, long address) {
            super(address);
            this.library = library;
        }
    }

    @Untraversable
    public static final class DataSymbol
    extends Symbol
    implements ExposeAsSuperclass {
        public DataSymbol(DynamicLibrary lib, String name, long address) {
            super(lib, name, new SymbolMemory(lib, address));
        }
    }

    @Untraversable
    public static final class TextSymbol
    extends Symbol
    implements ExposeAsSuperclass {
        public TextSymbol(DynamicLibrary lib, String name, long address) {
            super(lib, name, new SymbolMemory(lib, address));
        }
    }

    @Untraversable
    @ExposedType(name="jffi.DynamicLibrary.Symbol", base=PyObject.class)
    public static class Symbol
    extends BasePointer {
        public static final PyType TYPE;
        final DynamicLibrary library;
        final DirectMemory memory;
        public final String name;

        public Symbol(DynamicLibrary library, String name, DirectMemory memory) {
            super(TYPE);
            this.library = library;
            this.name = name;
            this.memory = memory;
        }

        @Override
        public final DirectMemory getMemory() {
            return this.memory;
        }

        static {
            PyType.addBuilder(Symbol.class, new DynamicLibrary$Symbol$PyExposer());
            TYPE = PyType.fromClass(Symbol.class);
        }
    }
}

