/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.ExposedType;
import org.python.modules.jffi.AllocatedNativeMemory;
import org.python.modules.jffi.ByReference;
import org.python.modules.jffi.CData$PyExposer;
import org.python.modules.jffi.CType;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.DynamicLibrary;
import org.python.modules.jffi.Memory;
import org.python.modules.jffi.MemoryOp;
import org.python.modules.jffi.PointerCData;

@ExposedType(name="jffi.CData", base=PyObject.class)
public abstract class CData
extends PyObject
implements Traverseproc {
    public static final PyType TYPE;
    private final CType ctype;
    private DirectMemory referenceMemory;

    CData(PyType subtype, CType ctype) {
        this(subtype, ctype, null);
    }

    CData(PyType subtype, CType ctype, DirectMemory memory) {
        super(subtype);
        this.ctype = ctype;
        this.referenceMemory = memory;
    }

    public PyObject byref(PyObject offset) {
        return new ByReference(this.ctype, (DirectMemory)this.getReferenceMemory().slice(offset.asInt()));
    }

    public PyObject pointer(PyObject pytype) {
        if (!(pytype instanceof PyType)) {
            throw Py.TypeError("expected type");
        }
        return new PointerCData((PyType)pytype, CType.typeOf(pytype), this.getReferenceMemory(), this.getMemoryOp());
    }

    public PyObject address() {
        return Py.newInteger(this.getReferenceMemory().getAddress());
    }

    final CType getCType() {
        return this.ctype;
    }

    MemoryOp getMemoryOp() {
        return this.getCType().getMemoryOp();
    }

    final boolean hasReferenceMemory() {
        return this.referenceMemory != null;
    }

    final void setReferenceMemory(Memory memory) {
        if (!(memory instanceof DirectMemory)) {
            throw Py.TypeError("invalid memory");
        }
        this.referenceMemory = (DirectMemory)memory;
    }

    public final DirectMemory getReferenceMemory() {
        if (this.referenceMemory != null) {
            return this.referenceMemory;
        }
        return this.allocateReferenceMemory();
    }

    protected DirectMemory allocateReferenceMemory() {
        AllocatedNativeMemory m = AllocatedNativeMemory.allocate(this.getCType().size(), false);
        this.initReferenceMemory(m);
        this.referenceMemory = m;
        return m;
    }

    public Memory getContentMemory() {
        return this.getReferenceMemory();
    }

    protected abstract void initReferenceMemory(Memory var1);

    protected static final DirectMemory findInDll(PyObject lib, PyObject name) {
        if (!(lib instanceof DynamicLibrary)) {
            throw Py.TypeError("expected library, not " + lib.getType().fastGetName());
        }
        DynamicLibrary.Symbol sym = (DynamicLibrary.Symbol)((DynamicLibrary)lib).find_symbol(name);
        return sym.getMemory();
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        return this.ctype != null ? visit.visit(this.ctype, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && ob == this.ctype;
    }

    static {
        PyType.addBuilder(CData.class, new CData$PyExposer());
        TYPE = PyType.fromClass(CData.class);
    }
}

