/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import jline.WindowsTerminal;
import jline.console.ConsoleReader;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.openksavi.sponge.jython.shaded.jnr.constants.platform.Errno;
import org.python.core.PlainConsole;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.util.ConsoleInputStream;
import org.python.util.ConsoleOutputStream;

public class JLineConsole
extends PlainConsole {
    public ConsoleReader reader;
    protected PyObject startup_hook;
    protected PyObject pre_input_hook;
    private boolean windows;
    protected static final String CTRL_Z = "\u001a";
    private ConsoleOutputStream outWrapper;
    private static final List<String> SUSPENDED_STRERRORS = Arrays.asList(Errno.EINTR.description(), Errno.EIO.description());

    public JLineConsole(String encoding) {
        super(encoding);
        System.setProperty("jline.WindowsTerminal.input.encoding", this.encoding);
        System.setProperty("input.encoding", this.encoding);
    }

    @Override
    public void install() {
        String userHomeSpec = System.getProperty("user.home", ".");
        try {
            FileInputStream in = new FileInputStream(FileDescriptor.in);
            this.reader = new ConsoleReader("jython", (InputStream)in, (OutputStream)System.out, null, this.encoding);
            this.reader.setKeyMap("jython");
            this.reader.setHandleUserInterrupt(true);
            this.reader.setCopyPasteDetection(true);
            this.reader.setBellEnabled(false);
            this.reader.setExpandEvents(false);
            this.outWrapper = new ConsoleOutputStream(System.out, this.reader.getTerminal().getWidth());
            System.setOut(new PrintStream((OutputStream)this.outWrapper, true, this.encoding));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            File historyFile = new File(userHomeSpec, ".jline-jython.history");
            FileHistory history = new FileHistory(historyFile);
            Runtime.getRuntime().addShutdownHook(new Thread(new HistoryCloser(history)));
            this.reader.setHistory((History)history);
        }
        catch (IOException historyFile) {
            // empty catch block
        }
        this.windows = this.reader.getTerminal() instanceof WindowsTerminal;
        Stream wrapper = new Stream();
        System.setIn(wrapper);
    }

    private String readerReadLine(String prompt) throws IOException, EOFException {
        while (true) {
            try {
                if (this.startup_hook != null) {
                    this.startup_hook.__call__();
                }
                try {
                    this.reader.getTerminal().init();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.reader.setPrompt(null);
                this.reader.redrawLine();
                return this.reader.readLine(prompt);
            }
            catch (IOException ioe) {
                if (!this.fromSuspend(ioe)) {
                    throw ioe;
                }
                try {
                    this.reader.resetPromptLine(prompt, null, 0);
                    prompt = "";
                }
                catch (Exception e) {
                    throw new IOException("Failed to re-initialize JLine: " + e.getMessage());
                }
            }
        }
    }

    private boolean fromSuspend(IOException ioe) {
        return !this.windows && SUSPENDED_STRERRORS.contains(ioe.getMessage());
    }

    private boolean isEOF(String line) {
        return line == null || this.windows && CTRL_Z.equals(line);
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    public PyObject getStartupHook() {
        return this.startup_hook;
    }

    public void setStartupHook(PyObject hook) {
        if (hook == Py.None) {
            hook = null;
        }
        this.startup_hook = hook;
    }

    private class Stream
    extends ConsoleInputStream {
        Stream() {
            super(System.in, JLineConsole.this.encodingCharset, ConsoleInputStream.EOLPolicy.ADD, LINE_SEPARATOR);
        }

        @Override
        protected CharSequence getLine() throws IOException, EOFException {
            String prompt = JLineConsole.this.outWrapper.getPrompt(JLineConsole.this.encodingCharset).toString();
            String line = JLineConsole.this.readerReadLine(prompt);
            if (!JLineConsole.this.isEOF(line)) {
                return line;
            }
            throw new EOFException();
        }
    }

    private static class HistoryCloser
    implements Runnable {
        FileHistory history;

        public HistoryCloser(FileHistory history) {
            this.history = history;
        }

        @Override
        public void run() {
            try {
                this.history.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

