/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.jython.shaded.jnr.ffi.provider.converters;

import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import java.util.Collection;
import org.openksavi.sponge.jython.shaded.jnr.ffi.annotations.Encoding;
import org.openksavi.sponge.jython.shaded.jnr.ffi.annotations.In;
import org.openksavi.sponge.jython.shaded.jnr.ffi.annotations.NulTerminate;
import org.openksavi.sponge.jython.shaded.jnr.ffi.mapper.MethodParameterContext;
import org.openksavi.sponge.jython.shaded.jnr.ffi.mapper.ToNativeContext;
import org.openksavi.sponge.jython.shaded.jnr.ffi.mapper.ToNativeConverter;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.converters.StringUtil;

@ToNativeConverter.NoContext
@ToNativeConverter.Cacheable
public class CharSequenceParameterConverter
implements ToNativeConverter<CharSequence, ByteBuffer> {
    private static final ToNativeConverter<CharSequence, ByteBuffer> DEFAULT = new CharSequenceParameterConverter(Charset.defaultCharset());
    private final ThreadLocal<Reference<CharsetEncoder>> localEncoder = new ThreadLocal();
    private final Charset charset;

    public static ToNativeConverter<CharSequence, ByteBuffer> getInstance(Charset charset2, ToNativeContext toNativeContext) {
        return Charset.defaultCharset().equals(charset2) ? DEFAULT : new CharSequenceParameterConverter(charset2);
    }

    public static ToNativeConverter<CharSequence, ByteBuffer> getInstance(ToNativeContext toNativeContext) {
        Charset cs;
        Charset charset2 = Charset.defaultCharset();
        if (toNativeContext instanceof MethodParameterContext) {
            cs = CharSequenceParameterConverter.getEncodingCharset(Arrays.asList(((MethodParameterContext)toNativeContext).getMethod().getDeclaringClass().getAnnotations()));
            if (cs != null) {
                charset2 = cs;
            }
            if ((cs = CharSequenceParameterConverter.getEncodingCharset(Arrays.asList(((MethodParameterContext)toNativeContext).getMethod().getAnnotations()))) != null) {
                charset2 = cs;
            }
        }
        if ((cs = CharSequenceParameterConverter.getEncodingCharset(toNativeContext.getAnnotations())) != null) {
            charset2 = cs;
        }
        return CharSequenceParameterConverter.getInstance(charset2, toNativeContext);
    }

    private static Charset getEncodingCharset(Collection<Annotation> annotations) {
        for (Annotation a : annotations) {
            if (!(a instanceof Encoding)) continue;
            return Charset.forName(((Encoding)a).value());
        }
        return null;
    }

    private CharSequenceParameterConverter(Charset charset2) {
        this.charset = charset2;
    }

    @Override
    public ByteBuffer toNative(CharSequence string2, ToNativeContext context) {
        CoderResult result2;
        if (string2 == null) {
            return null;
        }
        CharsetEncoder encoder2 = StringUtil.getEncoder(this.charset, this.localEncoder);
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[(int)((float)string2.length() * encoder2.averageBytesPerChar()) + 4]);
        CharBuffer charBuffer = CharBuffer.wrap(string2);
        encoder2.reset();
        while (!(!charBuffer.hasRemaining() || (result2 = encoder2.encode(charBuffer, byteBuffer, true)).isUnderflow() && (result2 = encoder2.flush(byteBuffer)).isUnderflow())) {
            if (result2.isOverflow()) {
                byteBuffer = CharSequenceParameterConverter.grow(byteBuffer);
                continue;
            }
            StringUtil.throwException(result2);
        }
        if (byteBuffer.remaining() <= 4) {
            byteBuffer = CharSequenceParameterConverter.grow(byteBuffer);
        }
        byteBuffer.position(byteBuffer.position() + 4);
        byteBuffer.flip();
        return byteBuffer;
    }

    private static ByteBuffer grow(ByteBuffer oldBuffer) {
        ByteBuffer buf = ByteBuffer.wrap(new byte[oldBuffer.capacity() * 2]);
        oldBuffer.flip();
        buf.put(oldBuffer);
        return buf;
    }

    @Override
    @In
    @NulTerminate
    public Class<ByteBuffer> nativeType() {
        return ByteBuffer.class;
    }
}

