/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.jython.shaded.jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import org.openksavi.sponge.jython.shaded.jnr.ffi.CallingConvention;
import org.openksavi.sponge.jython.shaded.jnr.ffi.NativeType;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.ParameterType;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.ResultType;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.SigType;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.jffi.AbstractFastNumericMethodGenerator;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.jffi.CodegenUtils;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.jffi.FastIntMethodGenerator;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.jffi.NumberUtil;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.jffi.Util;

public class FastLongMethodGenerator
extends AbstractFastNumericMethodGenerator {
    private static final boolean ENABLED = Util.getBooleanProperty("org.openksavi.sponge.jython.shaded.jnr.ffi.fast-long.enabled", true);
    private static final int MAX_PARAMETERS = FastLongMethodGenerator.getMaximumFastLongParameters();
    private static final String[] signatures;
    private static final String[] methodNames;

    @Override
    String getInvokerMethodName(ResultType resultType, ParameterType[] parameterTypes, boolean ignoreErrno) {
        int parameterCount = parameterTypes.length;
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    @Override
    String getInvokerSignature(int parameterCount, Class nativeIntType) {
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    @Override
    Class getInvokerType() {
        return Long.TYPE;
    }

    @Override
    public boolean isSupported(ResultType resultType, ParameterType[] parameterTypes, CallingConvention callingConvention) {
        int parameterCount = parameterTypes.length;
        if (!ENABLED) {
            return false;
        }
        if (callingConvention != CallingConvention.DEFAULT || parameterCount > MAX_PARAMETERS) {
            return false;
        }
        Platform platform2 = Platform.getPlatform();
        if (platform2.getCPU() != Platform.CPU.X86_64) {
            return false;
        }
        if (platform2.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        for (ParameterType parameterType : parameterTypes) {
            if (FastLongMethodGenerator.isFastLongParameter(platform2, parameterType)) continue;
            return false;
        }
        return FastLongMethodGenerator.isFastLongResult(platform2, resultType);
    }

    static int getMaximumFastLongParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeL6", CallContext.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            return 6;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private static boolean isFastLongType(Platform platform2, SigType type) {
        return FastIntMethodGenerator.isFastIntType(platform2, type) || type.getNativeType() == NativeType.ADDRESS && NumberUtil.sizeof(NativeType.ADDRESS) == 8 || type.getNativeType() == NativeType.SLONG || type.getNativeType() == NativeType.ULONG || type.getNativeType() == NativeType.SLONGLONG || type.getNativeType() == NativeType.ULONGLONG;
    }

    static boolean isFastLongResult(Platform platform2, ResultType resultType) {
        return FastLongMethodGenerator.isFastLongType(platform2, resultType) || resultType.getNativeType() == NativeType.VOID || resultType.getNativeType() == NativeType.ADDRESS && NumberUtil.sizeof(NativeType.ADDRESS) == 8;
    }

    static boolean isFastLongParameter(Platform platform2, ParameterType type) {
        return FastLongMethodGenerator.isFastLongType(platform2, type);
    }

    static {
        methodNames = new String[]{"invokeL0", "invokeL1", "invokeL2", "invokeL3", "invokeL4", "invokeL5", "invokeL6"};
        signatures = new String[MAX_PARAMETERS + 1];
        for (int i = 0; i <= MAX_PARAMETERS; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append('(').append(CodegenUtils.ci(CallContext.class)).append(CodegenUtils.ci(Long.TYPE));
            for (int n = 0; n < i; ++n) {
                sb.append('J');
            }
            FastLongMethodGenerator.signatures[i] = sb.append(")J").toString();
        }
    }
}

