/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.jython.shaded.org.antlr.analysis;

import org.openksavi.sponge.jython.shaded.org.antlr.analysis.SemanticContext;
import org.openksavi.sponge.jython.shaded.org.antlr.misc.IntSet;
import org.openksavi.sponge.jython.shaded.org.antlr.misc.IntervalSet;
import org.openksavi.sponge.jython.shaded.org.antlr.tool.Grammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Label
implements Comparable<Label>,
Cloneable {
    public static final int INVALID = -7;
    public static final int ACTION = -6;
    public static final int EPSILON = -5;
    public static final String EPSILON_STR = "<EPSILON>";
    public static final int SEMPRED = -4;
    public static final int SET = -3;
    public static final int EOT = -2;
    public static final int EOF = -1;
    public static final int NUM_FAUX_LABELS = 7;
    public static final int MIN_ATOM_VALUE = -2;
    public static final int MIN_CHAR_VALUE = 0;
    public static final int MAX_CHAR_VALUE = 65535;
    public static final int EOR_TOKEN_TYPE = 1;
    public static final int DOWN = 2;
    public static final int UP = 3;
    public static final int MIN_TOKEN_TYPE = 4;
    protected int label;
    protected IntSet labelSet;

    public Label(int label) {
        this.label = label;
    }

    public Label(IntSet labelSet) {
        if (labelSet == null) {
            this.label = -3;
            this.labelSet = IntervalSet.of(-7);
            return;
        }
        int singleAtom = labelSet.getSingleElement();
        if (singleAtom != -7) {
            this.label = singleAtom;
            return;
        }
        this.label = -3;
        this.labelSet = labelSet;
    }

    public Object clone() {
        Label l;
        try {
            l = (Label)super.clone();
            l.label = this.label;
            l.labelSet = new IntervalSet();
            l.labelSet.addAll(this.labelSet);
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return l;
    }

    public void add(Label a) {
        if (this.isAtom()) {
            this.labelSet = IntervalSet.of(this.label);
            this.label = -3;
            if (a.isAtom()) {
                this.labelSet.add(a.getAtom());
            } else if (a.isSet()) {
                this.labelSet.addAll(a.getSet());
            } else {
                throw new IllegalStateException("can't add element to Label of type " + this.label);
            }
            return;
        }
        if (this.isSet()) {
            if (a.isAtom()) {
                this.labelSet.add(a.getAtom());
            } else if (a.isSet()) {
                this.labelSet.addAll(a.getSet());
            } else {
                throw new IllegalStateException("can't add element to Label of type " + this.label);
            }
            return;
        }
        throw new IllegalStateException("can't add element to Label of type " + this.label);
    }

    public boolean isAtom() {
        return this.label >= -2;
    }

    public boolean isEpsilon() {
        return this.label == -5;
    }

    public boolean isSemanticPredicate() {
        return false;
    }

    public boolean isAction() {
        return false;
    }

    public boolean isSet() {
        return this.label == -3;
    }

    public int getAtom() {
        if (this.isAtom()) {
            return this.label;
        }
        return -7;
    }

    public IntSet getSet() {
        if (this.label != -3) {
            return IntervalSet.of(this.label);
        }
        return this.labelSet;
    }

    public void setSet(IntSet set) {
        this.label = -3;
        this.labelSet = set;
    }

    public SemanticContext getSemanticContext() {
        return null;
    }

    public boolean matches(int atom) {
        if (this.label == atom) {
            return true;
        }
        if (this.isSet()) {
            return this.labelSet.member(atom);
        }
        return false;
    }

    public boolean matches(IntSet set) {
        if (this.isAtom()) {
            return set.member(this.getAtom());
        }
        if (this.isSet()) {
            return !this.getSet().and(set).isNil();
        }
        return false;
    }

    public boolean matches(Label other) {
        if (other.isSet()) {
            return this.matches(other.getSet());
        }
        if (other.isAtom()) {
            return this.matches(other.getAtom());
        }
        return false;
    }

    public int hashCode() {
        if (this.label == -3) {
            return this.labelSet.hashCode();
        }
        return this.label;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.label != ((Label)o).label) {
            return false;
        }
        if (this.label == -3) {
            return this.labelSet.equals(((Label)o).labelSet);
        }
        return true;
    }

    @Override
    public int compareTo(Label o) {
        return this.label - o.label;
    }

    public String toString() {
        switch (this.label) {
            case -3: {
                return this.labelSet.toString();
            }
        }
        return String.valueOf(this.label);
    }

    public String toString(Grammar g) {
        switch (this.label) {
            case -3: {
                return this.labelSet.toString(g);
            }
        }
        return g.getTokenDisplayName(this.label);
    }

    public static boolean intersect(Label label, Label edgeLabel) {
        boolean hasIntersection = false;
        boolean labelIsSet = label.isSet();
        boolean edgeIsSet = edgeLabel.isSet();
        if (!labelIsSet && !edgeIsSet && edgeLabel.label == label.label) {
            hasIntersection = true;
        } else if (labelIsSet && edgeIsSet && !edgeLabel.getSet().and(label.getSet()).isNil()) {
            hasIntersection = true;
        } else if (labelIsSet && !edgeIsSet && label.getSet().member(edgeLabel.label)) {
            hasIntersection = true;
        } else if (!labelIsSet && edgeIsSet && edgeLabel.getSet().member(label.label)) {
            hasIntersection = true;
        }
        return hasIntersection;
    }
}

