/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.jython.shaded.jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.ObjectParameterType;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.openksavi.sponge.jython.shaded.jnr.ffi.Address;
import org.openksavi.sponge.jython.shaded.jnr.ffi.Pointer;
import org.openksavi.sponge.jython.shaded.jnr.ffi.Runtime;
import org.openksavi.sponge.jython.shaded.jnr.ffi.mapper.ToNativeContext;
import org.openksavi.sponge.jython.shaded.jnr.ffi.mapper.ToNativeConverter;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.jffi.BufferParameterStrategy;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.jffi.DirectMemoryIO;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.jffi.NullObjectParameterStrategy;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.jffi.ParameterStrategy;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.jffi.PointerParameterStrategy;
import org.openksavi.sponge.jython.shaded.jnr.ffi.provider.jffi.PrimitiveArrayParameterStrategy;

public final class AsmRuntime {
    public static final MemoryIO IO = MemoryIO.getInstance();

    private AsmRuntime() {
    }

    public static UnsatisfiedLinkError newUnsatisifiedLinkError(String msg) {
        return new UnsatisfiedLinkError(msg);
    }

    public static HeapInvocationBuffer newHeapInvocationBuffer(Function function) {
        return new HeapInvocationBuffer(function);
    }

    public static HeapInvocationBuffer newHeapInvocationBuffer(CallContext callContext) {
        return new HeapInvocationBuffer(callContext);
    }

    public static HeapInvocationBuffer newHeapInvocationBuffer(CallContext callContext, int objCount) {
        return new HeapInvocationBuffer(callContext, objCount);
    }

    public static Pointer pointerValue(long ptr, Runtime runtime) {
        return ptr != 0L ? new DirectMemoryIO(runtime, ptr) : null;
    }

    public static Pointer pointerValue(int ptr, Runtime runtime) {
        return ptr != 0 ? new DirectMemoryIO(runtime, ptr) : null;
    }

    public static boolean isDirect(Pointer ptr) {
        return ptr == null || ptr.isDirect();
    }

    public static int intValue(Pointer ptr) {
        return ptr != null ? (int)ptr.address() : 0;
    }

    public static long longValue(Pointer ptr) {
        return ptr != null ? ptr.address() : 0L;
    }

    public static long longValue(Address ptr) {
        return ptr != null ? ptr.longValue() : 0L;
    }

    public static int intValue(Address ptr) {
        return ptr != null ? ptr.intValue() : 0;
    }

    public static long longValue(Buffer ptr) {
        return ptr != null && ptr.isDirect() ? MemoryIO.getInstance().getDirectBufferAddress(ptr) : 0L;
    }

    public static int intValue(Buffer ptr) {
        return ptr != null && ptr.isDirect() ? (int)MemoryIO.getInstance().getDirectBufferAddress(ptr) : 0;
    }

    public static ParameterStrategy nullParameterStrategy() {
        return NullObjectParameterStrategy.NULL;
    }

    public static PointerParameterStrategy directPointerParameterStrategy() {
        return PointerParameterStrategy.DIRECT;
    }

    public static PointerParameterStrategy pointerParameterStrategy(Pointer pointer) {
        if (pointer == null || pointer.isDirect()) {
            return PointerParameterStrategy.DIRECT;
        }
        return AsmRuntime.otherPointerParameterStrategy(pointer);
    }

    private static PointerParameterStrategy otherPointerParameterStrategy(Pointer pointer) {
        if (pointer.hasArray()) {
            return PointerParameterStrategy.HEAP;
        }
        throw new RuntimeException("cannot convert " + pointer.getClass() + " to native");
    }

    public static BufferParameterStrategy bufferParameterStrategy(Buffer buffer, ObjectParameterType.ComponentType componentType) {
        if (buffer == null || buffer.isDirect()) {
            return BufferParameterStrategy.direct(componentType);
        }
        if (buffer.hasArray()) {
            return BufferParameterStrategy.heap(componentType);
        }
        throw new IllegalArgumentException("cannot marshal non-direct, non-array Buffer");
    }

    public static BufferParameterStrategy pointerParameterStrategy(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.BYTE);
        }
        if (buffer instanceof ShortBuffer) {
            return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.SHORT);
        }
        if (buffer instanceof CharBuffer) {
            return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.CHAR);
        }
        if (buffer instanceof IntBuffer) {
            return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.INT);
        }
        if (buffer instanceof LongBuffer) {
            return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.LONG);
        }
        if (buffer instanceof FloatBuffer) {
            return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.FLOAT);
        }
        if (buffer instanceof DoubleBuffer) {
            return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.DOUBLE);
        }
        if (buffer == null) {
            return BufferParameterStrategy.direct(ObjectParameterType.BYTE);
        }
        throw new IllegalArgumentException("unsupported java.nio.Buffer subclass: " + buffer.getClass());
    }

    public static BufferParameterStrategy pointerParameterStrategy(ByteBuffer buffer) {
        return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.BYTE);
    }

    public static BufferParameterStrategy pointerParameterStrategy(ShortBuffer buffer) {
        return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.SHORT);
    }

    public static BufferParameterStrategy pointerParameterStrategy(CharBuffer buffer) {
        return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.CHAR);
    }

    public static BufferParameterStrategy pointerParameterStrategy(IntBuffer buffer) {
        return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.INT);
    }

    public static BufferParameterStrategy pointerParameterStrategy(LongBuffer buffer) {
        return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.LONG);
    }

    public static BufferParameterStrategy pointerParameterStrategy(FloatBuffer buffer) {
        return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.FLOAT);
    }

    public static BufferParameterStrategy pointerParameterStrategy(DoubleBuffer buffer) {
        return AsmRuntime.bufferParameterStrategy(buffer, ObjectParameterType.DOUBLE);
    }

    public static ParameterStrategy pointerParameterStrategy(byte[] array) {
        return array != null ? PrimitiveArrayParameterStrategy.BYTE : NullObjectParameterStrategy.NULL;
    }

    public static ParameterStrategy pointerParameterStrategy(short[] array) {
        return array != null ? PrimitiveArrayParameterStrategy.SHORT : NullObjectParameterStrategy.NULL;
    }

    public static ParameterStrategy pointerParameterStrategy(char[] array) {
        return array != null ? PrimitiveArrayParameterStrategy.CHAR : NullObjectParameterStrategy.NULL;
    }

    public static ParameterStrategy pointerParameterStrategy(int[] array) {
        return array != null ? PrimitiveArrayParameterStrategy.INT : NullObjectParameterStrategy.NULL;
    }

    public static ParameterStrategy pointerParameterStrategy(long[] array) {
        return array != null ? PrimitiveArrayParameterStrategy.LONG : NullObjectParameterStrategy.NULL;
    }

    public static ParameterStrategy pointerParameterStrategy(float[] array) {
        return array != null ? PrimitiveArrayParameterStrategy.FLOAT : NullObjectParameterStrategy.NULL;
    }

    public static ParameterStrategy pointerParameterStrategy(double[] array) {
        return array != null ? PrimitiveArrayParameterStrategy.DOUBLE : NullObjectParameterStrategy.NULL;
    }

    public static ParameterStrategy pointerParameterStrategy(boolean[] array) {
        return array != null ? PrimitiveArrayParameterStrategy.BOOLEAN : NullObjectParameterStrategy.NULL;
    }

    public static void postInvoke(ToNativeConverter.PostInvocation postInvocation, Object j, Object n, ToNativeContext context) {
        try {
            postInvocation.postInvoke(j, n, context);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

